/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConsentExceptType {
    DENY,
    PERMIT,
    NULL;


    public static ConsentExceptType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("deny".equals(codeString)) {
            return DENY;
        }
        if ("permit".equals(codeString)) {
            return PERMIT;
        }
        throw new FHIRException("Unknown ConsentExceptType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DENY: {
                return "deny";
            }
            case PERMIT: {
                return "permit";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/consent-except-type";
    }

    public String getDefinition() {
        switch (this) {
            case DENY: {
                return "Consent is denied for actions meeting these rules";
            }
            case PERMIT: {
                return "Consent is provided for actions meeting these rules";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DENY: {
                return "Opt Out";
            }
            case PERMIT: {
                return "Opt In";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

