/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.elementmodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.conformance.ProfileUtilities;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.elementmodel.Element;
import org.hl7.fhir.dstu3.elementmodel.JsonParser;
import org.hl7.fhir.dstu3.elementmodel.Property;
import org.hl7.fhir.dstu3.formats.IParser;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Factory;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;

public class ObjectConverter {
    private IWorkerContext context;

    public ObjectConverter(IWorkerContext context) {
        this.context = context;
    }

    public Element convert(Resource ig) throws IOException, FHIRFormatError, DefinitionException {
        if (ig == null) {
            return null;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        org.hl7.fhir.dstu3.formats.JsonParser jp = new org.hl7.fhir.dstu3.formats.JsonParser();
        jp.compose(bs, ig);
        ByteArrayInputStream bi = new ByteArrayInputStream(bs.toByteArray());
        return new JsonParser(this.context).parse(bi);
    }

    public Element convert(Property property, Type type) throws FHIRException {
        return this.convertElement(property, type);
    }

    private Element convertElement(Property property, Base base) throws FHIRException {
        if (base == null) {
            return null;
        }
        String tn = base.fhirType();
        StructureDefinition sd = this.context.fetchTypeDefinition(tn);
        if (sd == null) {
            throw new FHIRException("Unable to find definition for type " + tn);
        }
        Element res = new Element(property.getName(), property);
        if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) {
            res.setValue(((PrimitiveType)base).asStringValue());
        }
        List<ElementDefinition> children = ProfileUtilities.getChildMap(sd, sd.getSnapshot().getElementFirstRep());
        for (ElementDefinition child : children) {
            Base[] values;
            String n = this.tail(child.getPath());
            if (sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE && "value".equals(n) || (values = base.getProperty(n.hashCode(), n, false)) == null) continue;
            for (Base value : values) {
                res.getChildren().add(this.convertElement(new Property(this.context, child, sd), value));
            }
        }
        return res;
    }

    private String tail(String path) {
        if (path.contains(".")) {
            return path.substring(path.lastIndexOf(46) + 1);
        }
        return path;
    }

    public Type convertToType(Element element) throws FHIRException {
        Type b = new Factory().create(element.fhirType());
        if (b instanceof PrimitiveType) {
            ((PrimitiveType)b).setValueAsString(element.primitiveValue());
        } else {
            for (Element child : element.getChildren()) {
                b.setProperty(child.getName(), this.convertToType(child));
            }
        }
        return b;
    }

    public Resource convert(Element element) throws FHIRException {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            new JsonParser(this.context).compose(element, bo, IParser.OutputStyle.NORMAL, null);
            return new org.hl7.fhir.dstu3.formats.JsonParser().parse(bo.toByteArray());
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    public static CodeableConcept readAsCodeableConcept(Element element) {
        CodeableConcept cc = new CodeableConcept();
        ArrayList<Element> list = new ArrayList<Element>();
        element.getNamedChildren("coding", list);
        for (Element item : list) {
            cc.addCoding(ObjectConverter.readAsCoding(item));
        }
        cc.setText(element.getNamedChildValue("text"));
        return cc;
    }

    public static Coding readAsCoding(Element item) {
        Coding c = new Coding();
        c.setSystem(item.getNamedChildValue("system"));
        c.setVersion(item.getNamedChildValue("version"));
        c.setCode(item.getNamedChildValue("code"));
        c.setDisplay(item.getNamedChildValue("display"));
        return c;
    }

    public static Identifier readAsIdentifier(Element item) {
        Identifier r = new Identifier();
        r.setSystem(item.getNamedChildValue("system"));
        r.setValue(item.getNamedChildValue("value"));
        return r;
    }

    public static Reference readAsReference(Element item) {
        Reference r = new Reference();
        r.setDisplay(item.getNamedChildValue("display"));
        r.setReference(item.getNamedChildValue("reference"));
        List<Element> identifier = item.getChildrenByName("identifier");
        if (!identifier.isEmpty()) {
            r.setIdentifier(ObjectConverter.readAsIdentifier(identifier.get(0)));
        }
        return r;
    }
}

