/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import com.github.rjeschke.txtmark.Processor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xml.XhtmlGeneratorAdorner;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XhtmlGenerator {
    private static final int LINE_LIMIT = 85;
    private XhtmlGeneratorAdorner adorner;

    public XhtmlGenerator(XhtmlGeneratorAdorner adorner) {
        this.adorner = adorner;
    }

    public String generateInsert(Document doc, String name, String desc) throws Exception {
        StringWriter out = new StringWriter();
        out.write("<div class=\"example\">\r\n");
        out.write("<p>Example Instance \"" + name + "\"" + (desc == null ? "" : ": " + Utilities.escapeXml(desc)) + "</p>\r\n");
        out.write("<pre class=\"xml\">\r\n");
        XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState state = null;
        for (int i = 0; i < doc.getChildNodes().getLength(); ++i) {
            this.writeNode(out, doc.getChildNodes().item(i), state, 0);
        }
        out.write("</pre>\r\n");
        out.write("</div>\r\n");
        out.flush();
        return out.toString();
    }

    public void generate(Document doc, OutputStream xhtml, String name, String desc, int level, boolean adorn, String filename) throws Exception {
        adorn = true;
        OutputStreamWriter out = new OutputStreamWriter(xhtml, "UTF-8");
        out.write("<div class=\"example\">\r\n");
        out.write("<p>" + Utilities.escapeXml(desc) + "</p>\r\n");
        if (adorn) {
            out.write("<pre class=\"xml\">\r\n");
            XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState state = null;
            for (int i = 0; i < doc.getChildNodes().getLength(); ++i) {
                this.writeNode(out, doc.getChildNodes().item(i), state, level);
            }
            out.write("</pre>\r\n");
        } else {
            out.write("<code class=\"xml\">\r\n");
            for (int i = 0; i < doc.getChildNodes().getLength(); ++i) {
                this.writeNodePlain(out, doc.getChildNodes().item(i), level);
            }
            out.write("</code>\r\n");
        }
        out.write("</div>\r\n");
        out.flush();
    }

    private void writeNodePlain(Writer out, Node node, int level) throws FHIRException, DOMException, IOException {
        if (node.getNodeType() == 1) {
            this.writeElementPlain(out, (Element)node, level);
        } else if (node.getNodeType() == 3) {
            this.writeTextPlain(out, (Text)node, level);
        } else if (node.getNodeType() == 8) {
            this.writeCommentPlain(out, (Comment)node, level);
        } else if (node.getNodeType() == 7) {
            this.writeProcessingInstructionPlain(out, (ProcessingInstruction)node);
        } else if (node.getNodeType() != 2) {
            throw new FHIRException("Unhandled node type");
        }
    }

    private void writeNode(Writer out, Node node, XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState state, int level) throws Exception {
        if (node.getNodeType() == 1) {
            this.writeElement(out, (Element)node, state, level);
        } else if (node.getNodeType() == 3) {
            this.writeText(out, (Text)node, level);
        } else if (node.getNodeType() == 8) {
            this.writeComment(out, (Comment)node, level);
        } else if (node.getNodeType() == 7) {
            this.writeProcessingInstruction(out, (ProcessingInstruction)node);
        } else if (node.getNodeType() != 2) {
            throw new FHIRException("Unhandled node type");
        }
    }

    private void writeProcessingInstruction(Writer out, ProcessingInstruction node) {
    }

    private void writeProcessingInstructionPlain(Writer out, ProcessingInstruction node) {
    }

    private void writeComment(Writer out, Comment node, int level) throws DOMException, IOException {
        String cmt = node.getTextContent();
        cmt = cmt.contains(":md:") ? this.processMarkdown(cmt.replace(":md:", "")) : this.escapeHtml(cmt, level);
        out.write("<span class=\"xmlcomment\">&lt;!-- " + cmt + " --&gt;</span>");
    }

    private void writeCommentPlain(Writer out, Comment node, int level) throws DOMException, IOException {
        String cmt = node.getTextContent();
        cmt = cmt.contains(":md:") ? this.processMarkdown(cmt.replace(":md:", "")) : Utilities.escapeXml(cmt);
        out.write("<!-- " + cmt + " -->");
    }

    private String processMarkdown(String text) {
        return Processor.process((String)text);
    }

    private void writeText(Writer out, Text node, int level) throws DOMException, IOException {
        out.write("<b>" + this.escapeHtml(Utilities.escapeXml(node.getTextContent()), level) + "</b>");
    }

    private void writeTextPlain(Writer out, Text node, int level) throws DOMException, IOException {
        out.write(Utilities.escapeXml(node.getTextContent()));
    }

    private void writeElement(Writer out, Element node, XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState state, int level) throws Exception {
        int i;
        XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState newstate;
        String link;
        String string = link = this.adorner == null ? null : this.adorner.getLink(this, state, node);
        if (link != null) {
            out.write("<span class=\"xmltag\">&lt;<a href=\"" + link + "\" class=\"xmltag\">" + node.getNodeName() + "</a></span>");
        } else {
            out.write("<span class=\"xmltagred\">&lt;" + node.getNodeName() + "</span>");
        }
        if (node.hasAttributes()) {
            out.write("<span class=\"xmlattr\">");
            out.write("<a name=\"" + this.adorner.getNodeId(state, node) + "\"> </a>");
            newstate = this.adorner == null ? new XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState(null, "", "") : this.adorner.getState(this, state, node);
            for (i = 0; i < node.getAttributes().getLength(); ++i) {
                if (i > 0) {
                    out.write(" ");
                }
                if (this.adorner != null) {
                    XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState attrState = this.adorner.getAttributeMarkup(this, newstate, node, node.getAttributes().item(i).getNodeName(), node.getAttributes().item(i).getTextContent());
                    out.write(node.getAttributes().item(i).getNodeName() + "=\"<span class=\"xmlattrvalue\">" + attrState.getPrefix() + this.escapeHtml(Utilities.escapeXml(node.getAttributes().item(i).getTextContent()), level) + attrState.getSuffix() + "</span>\"");
                    continue;
                }
                out.write(node.getAttributes().item(i).getNodeName() + "=\"<span class=\"xmlattrvalue\">" + this.escapeHtml(Utilities.escapeXml(node.getAttributes().item(i).getTextContent()), level) + "</span>\"");
            }
            out.write("</span>");
        }
        if (node.hasChildNodes()) {
            out.write("<span class=\"xmltag\">&gt;</span>");
            if (!node.hasAttributes()) {
                out.write("<a name=\"" + this.adorner.getNodeId(state, node) + "\"> </a>");
            }
            XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState xhtmlGeneratorAdornerState = newstate = this.adorner == null ? new XhtmlGeneratorAdorner.XhtmlGeneratorAdornerState(null, "", "") : this.adorner.getState(this, state, node);
            if (newstate.isSuppress()) {
                out.write("<span class=\"xmlcomment\">&lt;!-- " + this.escapeHtml(newstate.getSupressionMessage(), level) + " --&gt;</span>");
            } else {
                out.write(newstate.getPrefix());
                for (i = 0; i < node.getChildNodes().getLength(); ++i) {
                    this.writeNode(out, node.getChildNodes().item(i), newstate, level + 2);
                }
                out.write(newstate.getSuffix());
            }
            if (link != null) {
                out.write("<span class=\"xmltag\">&lt;/<a href=\"" + link + "\" class=\"xmltag\">" + node.getNodeName() + "</a>&gt;</span>");
            } else {
                out.write("<span class=\"xmltag\">&lt;/" + node.getNodeName() + "&gt;</span>");
            }
        } else {
            out.write("<span class=\"xmltag\">/&gt;</span>");
            if (!node.hasAttributes()) {
                out.write("<a name=\"" + this.adorner.getNodeId(state, node) + "\"> </a>");
            }
        }
        out.write("<a name=\"" + this.adorner.getNodeId(state, node) + "-end\"> </a>");
    }

    private void writeElementPlain(Writer out, Element node, int level) throws IOException, FHIRException {
        int i;
        out.write("<" + node.getNodeName());
        if (node.hasAttributes()) {
            for (i = 0; i < node.getAttributes().getLength(); ++i) {
                out.write(" " + node.getAttributes().item(i).getNodeName() + "=\"" + Utilities.escapeXml(node.getAttributes().item(i).getTextContent()) + "\"");
            }
        }
        if (node.hasChildNodes()) {
            out.write(">");
            for (i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.writeNodePlain(out, node.getChildNodes().item(i), level + 2);
            }
            out.write("</" + node.getNodeName() + ">");
        } else {
            out.write("/>");
        }
    }

    private String escapeHtml(String doco, int indent) {
        if (doco == null) {
            return "";
        }
        int i = 0;
        StringBuilder b = new StringBuilder();
        for (char c : doco.toCharArray()) {
            ++i;
            if (c == '\r' || c == '\n') {
                i = 0;
            }
            if (i > 85 && c == ' ' || i > 100) {
                b.append("\r\n");
                for (int j = 0; j < indent; ++j) {
                    b.append(" ");
                }
                i = 0;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '\t') {
                b.append("  ");
                continue;
            }
            if (c == '\'') {
                b.append("&apos;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }
}

