/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum.tests;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hl7.fhir.exceptions.UcumException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.Pair;
import org.hl7.fhir.utilities.ucum.UcumEssenceService;
import org.hl7.fhir.utilities.ucum.UcumService;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class UcumTester {
    private String definitions;
    private String tests;
    private UcumService ucumSvc;
    private int errCount;

    public static void main(String[] args) throws XmlPullParserException, IOException, UcumException {
        if (args.length == 0) {
            System.out.println("UCUM Tester - parameters:");
            System.out.println("  -definitions [filename] - filename for the UCUM definitions");
            System.out.println("  -tests [fileanme] - filename for the UCUM tests");
            System.out.println("See http://unitsofmeasure.org/trac/ for source files for both ucum definitions");
            System.out.println("(ucum-essence.xml) and tests (http://unitsofmeasure.org/trac/wiki/FunctionalTests)");
        } else {
            UcumTester worker = new UcumTester();
            for (int i = 0; i < args.length; ++i) {
                String a = args[i];
                ++i;
                if (a.equalsIgnoreCase("-definitions")) {
                    worker.setDefinitions(args[i]);
                    continue;
                }
                if (a.equalsIgnoreCase("-tests")) {
                    worker.setTests(args[i]);
                    continue;
                }
                System.out.println("Unknown parameter: '" + a + "'");
            }
            worker.execute();
        }
    }

    public String getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(String definitions) {
        this.definitions = definitions;
    }

    public String getTests() {
        return this.tests;
    }

    public void setTests(String tests) {
        this.tests = tests;
    }

    private void execute() throws XmlPullParserException, IOException, UcumException {
        this.testDecimal();
        this.ucumSvc = new UcumEssenceService(this.definitions);
        this.errCount = 0;
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput((InputStream)new FileInputStream(this.tests), null);
        int eventType = xpp.next();
        if (eventType != 2) {
            throw new XmlPullParserException("Unable to process XML document");
        }
        if (!xpp.getName().equals("ucumTests")) {
            throw new XmlPullParserException("Unable to process XML document: expected 'ucumTests' but found '" + xpp.getName() + "'");
        }
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                if (Utilities.isWhitespace(xpp.getText())) {
                    xpp.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xpp.getText());
            }
            if (xpp.getName().equals("history")) {
                this.skipElement(xpp);
                continue;
            }
            if (xpp.getName().equals("validation")) {
                this.runValidationTests(xpp);
                continue;
            }
            if (xpp.getName().equals("displayNameGeneration")) {
                this.runDisplayNameGeneration(xpp);
                continue;
            }
            if (xpp.getName().equals("conversion")) {
                this.runConversion(xpp);
                continue;
            }
            if (xpp.getName().equals("multiplication")) {
                this.runMultiplication(xpp);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xpp.getName());
        }
        xpp.next();
        if (this.errCount > 0) {
            System.err.println(Integer.toString(this.errCount) + " errors");
        }
    }

    private void runMultiplication(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                if (Utilities.isWhitespace(xpp.getText())) {
                    xpp.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xpp.getText());
            }
            if (xpp.getName().equals("case")) {
                this.runMultiplicationCase(xpp);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xpp.getName());
        }
        xpp.next();
    }

    private void runMultiplicationCase(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        String id = xpp.getAttributeValue(null, "id");
        String v1 = xpp.getAttributeValue(null, "v1");
        String u1 = xpp.getAttributeValue(null, "u1");
        String v2 = xpp.getAttributeValue(null, "v2");
        String u2 = xpp.getAttributeValue(null, "u2");
        String vRes = xpp.getAttributeValue(null, "vRes");
        String uRes = xpp.getAttributeValue(null, "uRes");
        Pair o1 = new Pair(new Decimal(v1), u1);
        Pair o2 = new Pair(new Decimal(v2), u2);
        Pair o3 = this.ucumSvc.multiply(o1, o2);
        this.debug("Multiplication Test " + id + ": the value '" + v1 + " " + u1 + "' * '" + v2 + " " + u2 + "' ==> " + o3.getValue().toString() + " " + o3.getCode());
        if (o3.getValue().comparesTo(new Decimal(vRes)) != 0 || !o3.getCode().equals(uRes)) {
            ++this.errCount;
            System.err.println("Test " + id + ": The value '" + vRes + " " + uRes + "' was expected, but the result was " + o3.getValue().toString() + " " + o3.getCode());
        }
        while (xpp.getEventType() != 3) {
            xpp.next();
        }
        xpp.next();
    }

    private void testDecimal() throws UcumException {
        this.testAsInteger();
        this.testStringSupport();
        this.testCompares();
        this.testAddition();
        this.testMultiplication();
    }

    private void testMultiplication() throws UcumException {
        this.testMultiply("2", "2", "4");
        this.testMultiply("2", "0.5", "1");
        this.testMultiply("0", "0", "0");
        this.testMultiply("0", "1", "0");
        this.testMultiply("4", "4", "16");
        this.testMultiply("20", "20", "400");
        this.testMultiply("200", "20", "4000");
        this.testMultiply("400", "400", "160000");
        this.testMultiply("2.0", "2.0", "4.0");
        this.testMultiply("2.00", "2.0", "4.0");
        this.testMultiply("2.0", "0.2", "0.4");
        this.testMultiply("2.0", "0.20", "0.40");
        this.testMultiply("13", "13", "169");
        this.testMultiply("12", "89", "1068");
        this.testMultiply("1234", "6789", "8377626");
        this.testMultiply("10000", "0.0001", "1");
        this.testMultiply("10000", "0.00010", "1.0");
        this.testMultiply("10000", "0.000100", "1.00");
        this.testMultiply("10000", "0.0001000", "1.000");
        this.testMultiply("10000", "0.00010000", "1.0000");
        this.testMultiply("10000", "0.000100000", "1.00000");
        this.testMultiply("10000.0", "0.000100000", "1.00000");
        this.testMultiply("10000.0", "0.0001000000", "1.00000");
        this.testMultiply("10000.0", "0.00010000000", "1.00000");
        this.testMultiply("2", "-2", "-4");
        this.testMultiply("-2", "2", "-4");
        this.testMultiply("-2", "-2", "4");
        this.testMultiply("35328734682734", "2349834295876423", "83016672387407213199375780482");
        this.testMultiply("35328734682734000000000", "2349834295876423000000000", "83016672387407213199375780482000000000000000000");
        this.testMultiply("3532873468.2734", "23498342958.76423", "83016672387407213199.375780482");
        this.testDivide("500", "4", "125");
        this.testDivide("1260257", "37", "34061");
        this.testDivide("127", "4", "31.75");
        this.testDivide("10", "10", "1");
        this.testDivide("1", "1", "1");
        this.testDivide("10", "3", "3.3");
        this.testDivide("10.0", "3", "3.33");
        this.testDivide("10.00", "3", "3.333");
        this.testDivide("10.00", "3.0", "3.3");
        this.testDivide("100", "1", "100");
        this.testDivide("1000", "10", "100");
        this.testDivide("100001", "10", "10000.1");
        this.testDivide("100", "10", "10");
        this.testDivide("1", "10", "0.1");
        this.testDivide("1", "15", "0.067");
        this.testDivide("1.0", "15", "0.067");
        this.testDivide("1.00", "15.0", "0.0667");
        this.testDivide("1", "0.1", "10");
        this.testDivide("1", "0.10", "10");
        this.testDivide("1", "0.010", "100");
        this.testDivide("1", "1.5", "0.67");
        this.testDivide("1.0", "1.5", "0.67");
        this.testDivide("10", "1.5", "6.7");
        this.testDivide("-1", "1", "-1");
        this.testDivide("1", "-1", "-1");
        this.testDivide("-1", "-1", "1");
        this.testDivide("2", "2", "1");
        this.testDivide("20", "2", "10");
        this.testDivide("22", "2", "11");
        this.testDivide("83016672387407213199375780482", "2349834295876423", "35328734682734");
        this.testDivide("83016672387407213199375780482000000000000000000", "2349834295876423000000000", "35328734682734000000000");
        this.testDivide("83016672387407213199.375780482", "23498342958.76423", "3532873468.2734");
        this.testDivInt("500", "4", "125");
        this.testDivInt("1260257", "37", "34061");
        this.testDivInt("127", "4", "31");
        this.testDivInt("10", "10", "1");
        this.testDivInt("1", "1", "1");
        this.testDivInt("100", "1", "100");
        this.testDivInt("1000", "10", "100");
        this.testDivInt("100001", "10", "10000");
        this.testDivInt("1", "1.5", "0");
        this.testDivInt("10", "1.5", "6");
        this.testModulo("10", "1", "0");
        this.testModulo("7", "4", "3");
        this.testMultiply("2", "2", "4");
        this.testMultiply("2.0", "2.0", "4.0");
        this.testMultiply("2.00", "2.0", "4.0");
        this.testDivide("10", "3", "3.3");
        this.testDivide("10.0", "3", "3.33");
        this.testDivide("10.00", "3", "3.333");
        this.testDivide("10.00", "3.0", "3.3");
        this.testDivide("10", "3.0", "3.3");
    }

    private void testModulo(String s1, String s2, String s3) throws UcumException {
        Decimal v1 = new Decimal(s1);
        Decimal v2 = new Decimal(s2);
        Decimal v3 = v1.modulo(v2);
        this.check(v3.asDecimal().equals(s3), s1 + " % " + s2 + " = " + s3 + ", but the library returned " + v3.asDecimal());
    }

    private void testDivInt(String s1, String s2, String s3) throws UcumException {
        Decimal v1 = new Decimal(s1);
        Decimal v2 = new Decimal(s2);
        Decimal v3 = v1.divInt(v2);
        this.check(v3.asDecimal().equals(s3), s1 + " /(int) " + s2 + " = " + s3 + ", but the library returned " + v3.asDecimal());
    }

    private void testDivide(String s1, String s2, String s3) throws UcumException {
        Decimal v1 = new Decimal(s1);
        Decimal v2 = new Decimal(s2);
        Decimal v3 = v1.divide(v2);
        this.check(v3.asDecimal().equals(s3), s1 + " / " + s2 + " = " + s3 + ", but the library returned " + v3.asDecimal());
    }

    private void testMultiply(String s1, String s2, String s3) throws UcumException {
        Decimal v1 = new Decimal(s1);
        Decimal v2 = new Decimal(s2);
        Decimal v3 = v1.multiply(v2);
        this.check(v3.asDecimal().equals(s3), s1 + " * " + s2 + " = " + s3 + ", but the library returned " + v3.asDecimal());
    }

    private void testAddition() throws UcumException {
        this.testAdd("1", "1", "2");
        this.testAdd("0", "1", "1");
        this.testAdd("0", "0", "0");
        this.testAdd("5", "5", "10");
        this.testAdd("10", "1", "11");
        this.testAdd("11", "12", "23");
        this.testAdd("15", "16", "31");
        this.testAdd("150", "160", "310");
        this.testAdd("153", "168", "321");
        this.testAdd("15300000000000000000000000000000000001", "1680", "15300000000000000000000000000000001681");
        this.testAdd("1", ".1", "1.1");
        this.testAdd("1", ".001", "1.001");
        this.testAdd(".1", ".1", "0.2");
        this.testAdd(".1", ".01", "0.11");
        this.testSubtract("2", "1", "1");
        this.testSubtract("2", "0", "2");
        this.testSubtract("0", "0", "0");
        this.testSubtract("0", "2", "-2");
        this.testSubtract("2", "2", "0");
        this.testSubtract("1", "2", "-1");
        this.testSubtract("20", "1", "19");
        this.testSubtract("2", ".1", "1.9");
        this.testSubtract("2", ".000001", "1.999999");
        this.testSubtract("2", "2.000001", "-0.000001");
        this.testSubtract("3.5", "35.5", "-32.0");
        this.testAdd("5", "6", "11");
        this.testAdd("5", "-6", "-1");
        this.testAdd("-5", "6", "1");
        this.testAdd("-5", "-6", "-11");
        this.testSubtract("5", "6", "-1");
        this.testSubtract("6", "5", "1");
        this.testSubtract("5", "-6", "11");
        this.testSubtract("6", "-5", "11");
        this.testSubtract("-5", "6", "-11");
        this.testSubtract("-6", "5", "-11");
        this.testSubtract("-5", "-6", "1");
        this.testSubtract("-6", "-5", "-1");
        this.testAdd("2", "0.001", "2.001");
        this.testAdd("2.0", "0.001", "2.001");
    }

    private void testSubtract(String s1, String s2, String s3) throws UcumException {
        Decimal v1 = new Decimal(s1);
        Decimal v2 = new Decimal(s2);
        Decimal v3 = v1.subtract(v2);
        this.check(v3.asDecimal().equals(s3), s1 + " - " + s2 + " = " + s3 + ", but the library returned " + v3.asDecimal());
    }

    private void testAdd(String s1, String s2, String s3) throws UcumException {
        Decimal v1 = new Decimal(s1);
        Decimal v2 = new Decimal(s2);
        Decimal v3 = v1.add(v2);
        this.check(v3.asDecimal().equals(s3), s1 + " + " + s2 + " = " + s3 + ", but the library returned " + v3.asDecimal());
    }

    private void testCompares() throws UcumException {
        this.testCompares("1", "1", 0);
        this.testCompares("0", "0", 0);
        this.testCompares("0", "1", -1);
        this.testCompares("1", "0", 1);
        this.testCompares("10", "10", 0);
        this.testCompares("100", "100", 0);
        this.testCompares("0.1", "0.1", 0);
        this.testCompares("0.01", "0.01", 0);
        this.testCompares("0.01", "0.0100", 0);
        this.testCompares("1", "1.00000000", 0);
        this.testCompares("1.111111", "1.111111", 0);
    }

    private void testCompares(String v1, String v2, int outcome) throws UcumException {
        Decimal d1 = new Decimal(v1);
        Decimal d2 = new Decimal(v2);
        int result = d1.comparesTo(d2);
        this.check(result == outcome, "Compare fail: " + v1 + ".compares(" + v2 + ") should be " + Integer.toString(outcome) + " but was " + Integer.toString(result));
    }

    private void testStringSupport() throws UcumException {
        this.testString("1", "1", "1e0");
        this.testString("0", "0", "0e0");
        this.testString("10", "10", "1.0e1");
        this.testString("99", "99", "9.9e1");
        this.testString("-1", "-1", "-1e0");
        this.testString("-0", "0", "0e0");
        this.testString("-10", "-10", "-1.0e1");
        this.testString("-99", "-99", "-9.9e1");
        this.testString("1.1", "1.1", "1.1e0");
        this.testString("-1.1", "-1.1", "-1.1e0");
        this.testString("11.1", "11.1", "1.11e1");
        this.testString("1.11", "1.11", "1.11e0");
        this.testString("1.111", "1.111", "1.111e0");
        this.testString("0.1", "0.1", "1e-1");
        this.testString("00.1", "0.1", "1e-1");
        this.testString(".1", "0.1", "1e-1");
        this.testString("1.0", "1.0", "1.0e0");
        this.testString("1.00", "1.00", "1.00e0");
        this.testString("1.000000000000000000000000000000000000000", "1.000000000000000000000000000000000000000", "1.000000000000000000000000000000000000000e0");
        this.testString("-11.1", "-11.1", "-1.11e1");
        this.testString("-1.11", "-1.11", "-1.11e0");
        this.testString("-1.111", "-1.111", "-1.111e0");
        this.testString("-0.1", "-0.1", "-1e-1");
        this.testString("-00.1", "-0.1", "-1e-1");
        this.testString("-.1", "-0.1", "-1e-1");
        this.testString("-1.0", "-1.0", "-1.0e0");
        this.testString("-1.00", "-1.00", "-1.00e0");
        this.testString("-1.000000000000000000000000000000000000000", "-1.000000000000000000000000000000000000000", "-1.000000000000000000000000000000000000000e0");
        this.testString("0.0", "0.0", "0.0e0");
        this.testString("0.0000", "0.0000", "0.0000e0");
        this.testString("0.1", "0.1", "1e-1");
        this.testString("00.1", "0.1", "1e-1");
        this.testString("0.100", "0.100", "1.00e-1");
        this.testString("100", "100", "1.00e2");
        this.testString("1.0", "1.0", "1.0e0");
        this.testString("1.1", "1.1", "1.1e0");
        this.testString("-0.1", "-0.1", "-1e-1");
        this.testString("0.01", "0.01", "1e-2");
        this.testString("0.001", "0.001", "1e-3");
        this.testString("0.0001", "0.0001", "1e-4");
        this.testString("00.0001", "0.0001", "1e-4");
        this.testString("000.0001", "0.0001", "1e-4");
        this.testString("-0.01", "-0.01", "-1e-2");
        this.testString("10.01", "10.01", "1.001e1");
        this.testString("0.0001", "0.0001", "1e-4");
        this.testString("0.00001", "0.00001", "1e-5");
        this.testString("0.000001", "0.000001", "1e-6");
        this.testString("0.0000001", "0.0000001", "1e-7");
        this.testString("0.000000001", "0.000000001", "1e-9");
        this.testString("0.00000000001", "0.00000000001", "1e-11");
        this.testString("0.0000000000001", "0.0000000000001", "1e-13");
        this.testString("0.000000000000001", "0.000000000000001", "1e-15");
        this.testString("0.00000000000000001", "0.00000000000000001", "1e-17");
        this.testString("10.1", "10.1", "1.01e1");
        this.testString("100.1", "100.1", "1.001e2");
        this.testString("1000.1", "1000.1", "1.0001e3");
        this.testString("10000.1", "10000.1", "1.00001e4");
        this.testString("100000.1", "100000.1", "1.000001e5");
        this.testString("1000000.1", "1000000.1", "1.0000001e6");
        this.testString("10000000.1", "10000000.1", "1.00000001e7");
        this.testString("100000000.1", "100000000.1", "1.000000001e8");
        this.testString("1000000000.1", "1000000000.1", "1.0000000001e9");
        this.testString("10000000000.1", "10000000000.1", "1.00000000001e10");
        this.testString("100000000000.1", "100000000000.1", "1.000000000001e11");
        this.testString("1000000000000.1", "1000000000000.1", "1.0000000000001e12");
        this.testString("10000000000000.1", "10000000000000.1", "1.00000000000001e13");
        this.testString("100000000000000.1", "100000000000000.1", "1.000000000000001e14");
        this.testTrunc("1", "1");
        this.testTrunc("1.01", "1");
        this.testTrunc("-1.01", "-1");
        this.testTrunc("0.01", "0");
        this.testTrunc("-0.01", "0");
        this.testTrunc("0.1", "0");
        this.testTrunc("0.0001", "0");
        this.testTrunc("100.000000000000000000000000000000000000000001", "100");
    }

    private void testTrunc(String s1, String s2) throws UcumException {
        Decimal o1 = new Decimal(s1);
        Decimal o2 = o1.trunc();
        this.check(o2.asDecimal().equals(s2), "wrong trunc - expected " + s2 + " but got " + o2.asDecimal());
    }

    private void testString(String s, String st, String std) throws UcumException {
        Decimal dec = new Decimal(s);
        String s1 = dec.toString();
        String s2 = dec.asScientific();
        this.check(s1.equals(st), "decimal: expected " + st + " but got " + s1);
        this.check(s2.equals(std), "scientific: expected " + std + " but got " + s2);
        dec = new Decimal(std);
        s1 = dec.asDecimal();
        this.check(s1.equals(st), "decimal(2): expected " + st + " but got " + s1);
    }

    private void testAsInteger() throws UcumException {
        this.testInteger(0);
        this.testInteger(1);
        this.testInteger(2);
        this.testInteger(64);
        this.testInteger(Integer.MAX_VALUE);
        this.testInteger(-1);
        this.testInteger(-2);
        this.testInteger(-64);
        this.testInteger(Integer.MIN_VALUE);
    }

    private void testInteger(int i) throws UcumException {
        Decimal d = new Decimal(i);
        this.check(d.asInteger() == i, "Failed to round trip the integer " + Integer.toString(i));
    }

    private void check(boolean b, String msg) {
        if (!b) {
            throw new Error(msg);
        }
    }

    private void runConversion(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                if (Utilities.isWhitespace(xpp.getText())) {
                    xpp.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xpp.getText());
            }
            if (xpp.getName().equals("case")) {
                this.runConversionCase(xpp);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xpp.getName());
        }
        xpp.next();
    }

    private void runConversionCase(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        String id = xpp.getAttributeValue(null, "id");
        String value = xpp.getAttributeValue(null, "value");
        String srcUnit = xpp.getAttributeValue(null, "srcUnit");
        String dstUnit = xpp.getAttributeValue(null, "dstUnit");
        String outcome = xpp.getAttributeValue(null, "outcome");
        System.out.println("case " + id + ": " + value + " " + srcUnit + " -> " + outcome + " " + dstUnit);
        Decimal res = this.ucumSvc.convert(new Decimal(value), srcUnit, dstUnit);
        this.debug("Convert Test " + id + ": the value '" + value + " " + srcUnit + "' ==> " + res.toString() + " " + dstUnit);
        if (res.comparesTo(new Decimal(outcome)) != 0) {
            ++this.errCount;
            System.err.println("Test " + id + ": The value '" + outcome + "' was expected the result was " + res.toString());
        }
        while (xpp.getEventType() != 3) {
            xpp.next();
        }
        xpp.next();
    }

    private void debug(String string) {
        System.out.println(string);
    }

    private void runDisplayNameGeneration(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                if (Utilities.isWhitespace(xpp.getText())) {
                    xpp.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xpp.getText());
            }
            if (xpp.getName().equals("case")) {
                this.runDisplayNameGenerationCase(xpp);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xpp.getName());
        }
        xpp.next();
    }

    private void runDisplayNameGenerationCase(XmlPullParser xpp) throws XmlPullParserException, IOException, UcumException {
        String id = xpp.getAttributeValue(null, "id");
        String unit = xpp.getAttributeValue(null, "unit");
        String display = xpp.getAttributeValue(null, "display");
        String res = this.ucumSvc.analyse(unit);
        this.debug("Analyse Test " + id + ": the unit '" + unit + "' ==> " + res);
        if (!res.equals(display)) {
            ++this.errCount;
            System.err.println("Test " + id + ": The unit '" + unit + "' was expected to be displayed as '" + display + "', but was displayed as " + res);
        }
        while (xpp.getEventType() != 3) {
            xpp.next();
        }
        xpp.next();
    }

    private void runValidationTests(XmlPullParser xpp) throws XmlPullParserException, IOException {
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                if (Utilities.isWhitespace(xpp.getText())) {
                    xpp.next();
                    continue;
                }
                throw new XmlPullParserException("Unexpected text " + xpp.getText());
            }
            if (xpp.getName().equals("case")) {
                this.runValidationCase(xpp);
                continue;
            }
            throw new XmlPullParserException("unknown element name " + xpp.getName());
        }
        xpp.next();
    }

    private void runValidationCase(XmlPullParser xpp) throws XmlPullParserException, IOException {
        boolean result;
        String id = xpp.getAttributeValue(null, "id");
        String unit = xpp.getAttributeValue(null, "unit");
        boolean valid = "true".equals(xpp.getAttributeValue(null, "valid"));
        String reason = xpp.getAttributeValue(null, "reason");
        String res = this.ucumSvc.validate(unit);
        boolean bl = result = res == null;
        if (result) {
            this.debug("Validation Test " + id + ": the unit '" + unit + "' is valid");
        } else {
            this.debug("Validation Test " + id + ": the unit '" + unit + "' is not valid because " + res);
        }
        if (valid != result) {
            ++this.errCount;
            if (valid) {
                System.err.println("Test " + id + ": The unit '" + unit + "' was expected to be valid, but wasn't accepted");
            } else {
                System.err.println("Test " + id + ": The unit '" + unit + "' was expected to be invalid because '" + reason + "', but was accepted");
            }
        }
        while (xpp.getEventType() != 3) {
            xpp.next();
        }
        xpp.next();
    }

    private void skipElement(XmlPullParser xpp) throws XmlPullParserException, IOException {
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 2) {
                this.skipElement(xpp);
                continue;
            }
            xpp.next();
        }
        xpp.next();
    }
}

