/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class DateRangeParam
implements IQueryParameterAnd<DateParam> {
    private static final long serialVersionUID = 1L;
    private DateParam myLowerBound;
    private DateParam myUpperBound;

    public DateRangeParam() {
    }

    public DateRangeParam(Date theLowerBound, Date theUpperBound) {
        this();
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateRangeParam(DateParam theDateParam) {
        this();
        if (theDateParam == null) {
            throw new NullPointerException("theDateParam can not be null");
        }
        if (theDateParam.isEmpty()) {
            throw new IllegalArgumentException("theDateParam can not be empty");
        }
        if (theDateParam.getPrefix() == null) {
            this.setRangeFromDatesInclusive(theDateParam.getValueAsString(), theDateParam.getValueAsString());
        } else {
            switch (theDateParam.getPrefix()) {
                case EQUAL: {
                    this.setRangeFromDatesInclusive(theDateParam.getValueAsString(), theDateParam.getValueAsString());
                    break;
                }
                case STARTS_AFTER: 
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    if (theDateParam.getPrecision().ordinal() <= TemporalPrecisionEnum.MONTH.ordinal()) {
                        theDateParam.setValueAsString((String)DateUtils.getCompletedDate(theDateParam.getValueAsString()).getRight());
                    }
                    this.validateAndSet(theDateParam, null);
                    break;
                }
                case ENDS_BEFORE: 
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    if (theDateParam.getPrecision().ordinal() <= TemporalPrecisionEnum.MONTH.ordinal()) {
                        theDateParam.setValueAsString((String)DateUtils.getCompletedDate(theDateParam.getValueAsString()).getLeft());
                    }
                    this.validateAndSet(null, theDateParam);
                    break;
                }
                default: {
                    throw new InvalidRequestException("Invalid comparator for date range parameter:" + (Object)((Object)theDateParam.getPrefix()) + ". This is a bug.");
                }
            }
        }
    }

    public DateRangeParam(DateParam theLowerBound, DateParam theUpperBound) {
        this();
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateRangeParam(IPrimitiveType<Date> theLowerBound, IPrimitiveType<Date> theUpperBound) {
        this();
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    public DateRangeParam(String theLowerBound, String theUpperBound) {
        this();
        this.setRangeFromDatesInclusive(theLowerBound, theUpperBound);
    }

    private void addParam(DateParam theParsed) throws InvalidRequestException {
        if (theParsed.getPrefix() == null || theParsed.getPrefix() == ParamPrefixEnum.EQUAL) {
            if (this.myLowerBound != null || this.myUpperBound != null) {
                throw new InvalidRequestException("Can not have multiple date range parameters for the same param without a qualifier");
            }
            if (theParsed.getMissing() != null) {
                this.myLowerBound = theParsed;
                this.myUpperBound = theParsed;
            } else {
                this.myLowerBound = new DateParam(ParamPrefixEnum.EQUAL, theParsed.getValueAsString());
                this.myUpperBound = new DateParam(ParamPrefixEnum.EQUAL, theParsed.getValueAsString());
            }
        } else {
            switch (theParsed.getPrefix()) {
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    if (this.myLowerBound != null) {
                        throw new InvalidRequestException("Can not have multiple date range parameters for the same param that specify a lower bound");
                    }
                    this.myLowerBound = theParsed;
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    if (this.myUpperBound != null) {
                        throw new InvalidRequestException("Can not have multiple date range parameters for the same param that specify an upper bound");
                    }
                    this.myUpperBound = theParsed;
                    break;
                }
                default: {
                    throw new InvalidRequestException("Unknown comparator: " + (Object)((Object)theParsed.getPrefix()));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DateRangeParam)) {
            return false;
        }
        DateRangeParam other = (DateRangeParam)obj;
        return Objects.equals(this.myLowerBound, other.myLowerBound) && Objects.equals(this.myUpperBound, other.myUpperBound);
    }

    public DateParam getLowerBound() {
        return this.myLowerBound;
    }

    public DateRangeParam setLowerBound(DateParam theLowerBound) {
        this.validateAndSet(theLowerBound, this.myUpperBound);
        return this;
    }

    public DateRangeParam setLowerBound(String theLowerBound) {
        this.setLowerBound(new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theLowerBound));
        return this;
    }

    public DateRangeParam setLowerBoundInclusive(Date theLowerBound) {
        this.validateAndSet(new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theLowerBound), this.myUpperBound);
        return this;
    }

    public DateRangeParam setUpperBoundInclusive(Date theUpperBound) {
        this.validateAndSet(this.myLowerBound, new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theUpperBound));
        return this;
    }

    public DateRangeParam setLowerBoundExclusive(Date theLowerBound) {
        this.validateAndSet(new DateParam(ParamPrefixEnum.GREATERTHAN, theLowerBound), this.myUpperBound);
        return this;
    }

    public DateRangeParam setUpperBoundExclusive(Date theUpperBound) {
        this.validateAndSet(this.myLowerBound, new DateParam(ParamPrefixEnum.LESSTHAN, theUpperBound));
        return this;
    }

    public Integer getLowerBoundAsDateInteger() {
        if (this.myLowerBound == null || this.myLowerBound.getValue() == null) {
            return null;
        }
        int retVal = DateUtils.convertDateToDayInteger(this.myLowerBound.getValue());
        if (this.myLowerBound.getPrefix() != null) {
            switch (this.myLowerBound.getPrefix()) {
                case STARTS_AFTER: 
                case GREATERTHAN: {
                    ++retVal;
                    break;
                }
                case EQUAL: 
                case GREATERTHAN_OR_EQUALS: {
                    break;
                }
                case ENDS_BEFORE: 
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: 
                case APPROXIMATE: 
                case NOT_EQUAL: {
                    throw new IllegalStateException("Invalid lower bound comparator: " + (Object)((Object)this.myLowerBound.getPrefix()));
                }
            }
        }
        return retVal;
    }

    public Integer getUpperBoundAsDateInteger() {
        if (this.myUpperBound == null || this.myUpperBound.getValue() == null) {
            return null;
        }
        int retVal = DateUtils.convertDateToDayInteger(this.myUpperBound.getValue());
        if (this.myUpperBound.getPrefix() != null) {
            switch (this.myUpperBound.getPrefix()) {
                case ENDS_BEFORE: 
                case LESSTHAN: {
                    --retVal;
                    break;
                }
                case EQUAL: 
                case LESSTHAN_OR_EQUALS: {
                    break;
                }
                case STARTS_AFTER: 
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: 
                case APPROXIMATE: 
                case NOT_EQUAL: {
                    throw new IllegalStateException("Invalid upper bound comparator: " + (Object)((Object)this.myUpperBound.getPrefix()));
                }
            }
        }
        return retVal;
    }

    public Date getLowerBoundAsInstant() {
        if (this.myLowerBound == null || this.myLowerBound.getValue() == null) {
            return null;
        }
        Date retVal = this.myLowerBound.getValue();
        if (this.myLowerBound.getPrecision().ordinal() <= TemporalPrecisionEnum.DAY.ordinal()) {
            retVal = DateUtils.getLowestInstantFromDate(retVal);
        }
        if (this.myLowerBound.getPrefix() != null) {
            switch (this.myLowerBound.getPrefix()) {
                case STARTS_AFTER: 
                case GREATERTHAN: {
                    retVal = this.myLowerBound.getPrecision().add(retVal, 1);
                    break;
                }
                case EQUAL: 
                case GREATERTHAN_OR_EQUALS: {
                    break;
                }
                case ENDS_BEFORE: 
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: 
                case APPROXIMATE: 
                case NOT_EQUAL: {
                    throw new IllegalStateException("Invalid lower bound comparator: " + (Object)((Object)this.myLowerBound.getPrefix()));
                }
            }
        }
        return retVal;
    }

    public DateParam getUpperBound() {
        return this.myUpperBound;
    }

    public DateRangeParam setUpperBound(String theUpperBound) {
        this.setUpperBound(new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theUpperBound));
        return this;
    }

    public DateRangeParam setUpperBound(DateParam theUpperBound) {
        this.validateAndSet(this.myLowerBound, theUpperBound);
        return this;
    }

    public Date getUpperBoundAsInstant() {
        if (this.myUpperBound == null || this.myUpperBound.getValue() == null) {
            return null;
        }
        Date retVal = this.myUpperBound.getValue();
        if (this.myUpperBound.getPrecision().ordinal() <= TemporalPrecisionEnum.DAY.ordinal()) {
            retVal = DateUtils.getHighestInstantFromDate(retVal);
        }
        if (this.myUpperBound.getPrefix() != null) {
            switch (this.myUpperBound.getPrefix()) {
                case ENDS_BEFORE: 
                case LESSTHAN: {
                    retVal = new Date(retVal.getTime() - 1L);
                    break;
                }
                case EQUAL: 
                case LESSTHAN_OR_EQUALS: {
                    retVal = this.myUpperBound.getPrecision().add(retVal, 1);
                    retVal = new Date(retVal.getTime() - 1L);
                    break;
                }
                case STARTS_AFTER: 
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: 
                case APPROXIMATE: 
                case NOT_EQUAL: {
                    throw new IllegalStateException("Invalid upper bound comparator: " + (Object)((Object)this.myUpperBound.getPrefix()));
                }
            }
        }
        return retVal;
    }

    @Override
    public List<DateParam> getValuesAsQueryTokens() {
        ArrayList<DateParam> retVal = new ArrayList<DateParam>();
        if (this.myLowerBound != null && this.myLowerBound.getMissing() != null) {
            retVal.add(this.myLowerBound);
        } else {
            if (this.myLowerBound != null && !this.myLowerBound.isEmpty()) {
                retVal.add(this.myLowerBound);
            }
            if (this.myUpperBound != null && !this.myUpperBound.isEmpty()) {
                retVal.add(this.myUpperBound);
            }
        }
        return retVal;
    }

    private boolean hasBound(DateParam bound) {
        return bound != null && !bound.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.myLowerBound, this.myUpperBound);
    }

    public boolean isEmpty() {
        return this.getLowerBoundAsInstant() == null && this.getUpperBoundAsInstant() == null;
    }

    public void setRangeFromDatesInclusive(Date theLowerBound, Date theUpperBound) {
        DateParam lowerBound = theLowerBound != null ? new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theLowerBound) : null;
        DateParam upperBound = theUpperBound != null ? new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theUpperBound) : null;
        this.validateAndSet(lowerBound, upperBound);
    }

    public void setRangeFromDatesInclusive(DateParam theLowerBound, DateParam theUpperBound) {
        this.validateAndSet(theLowerBound, theUpperBound);
    }

    public void setRangeFromDatesInclusive(IPrimitiveType<Date> theLowerBound, IPrimitiveType<Date> theUpperBound) {
        IPrimitiveType<Date> lowerBound = theLowerBound;
        IPrimitiveType<Date> upperBound = theUpperBound;
        if (lowerBound != null && lowerBound.getValue() != null && upperBound != null && upperBound.getValue() != null && lowerBound.getValue().after(upperBound.getValue())) {
            IPrimitiveType<Date> temp = lowerBound;
            lowerBound = upperBound;
            upperBound = temp;
        }
        this.validateAndSet(lowerBound != null ? new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, lowerBound) : null, upperBound != null ? new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, upperBound) : null);
    }

    public void setRangeFromDatesInclusive(String theLowerBound, String theUpperBound) {
        DateParam upperBound;
        DateParam lowerBound = theLowerBound != null ? new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, theLowerBound) : null;
        DateParam dateParam = upperBound = theUpperBound != null ? new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, theUpperBound) : null;
        if (StringUtils.isNotBlank((CharSequence)theLowerBound) && StringUtils.isNotBlank((CharSequence)theUpperBound) && theLowerBound.equals(theUpperBound)) {
            lowerBound.setPrefix(ParamPrefixEnum.EQUAL);
            upperBound.setPrefix(ParamPrefixEnum.EQUAL);
        }
        this.validateAndSet(lowerBound, upperBound);
    }

    @Override
    public void setValuesAsQueryTokens(FhirContext theContext, String theParamName, List<QualifiedParamList> theParameters) throws InvalidRequestException {
        boolean haveHadUnqualifiedParameter = false;
        for (QualifiedParamList paramList : theParameters) {
            if (paramList.size() == 0) continue;
            if (paramList.size() > 1) {
                throw new InvalidRequestException("DateRange parameter does not support OR queries");
            }
            String param = (String)paramList.get(0);
            param = param.replace(' ', '+');
            DateParam parsed = new DateParam();
            parsed.setValueAsQueryToken(theContext, theParamName, paramList.getQualifier(), param);
            this.addParam(parsed);
            if (parsed.getPrefix() != null) continue;
            if (haveHadUnqualifiedParameter) {
                throw new InvalidRequestException("Multiple date parameters with the same name and no qualifier (>, <, etc.) is not supported");
            }
            haveHadUnqualifiedParameter = true;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        if (this.hasBound(this.myLowerBound)) {
            if (this.myLowerBound.getPrefix() != null) {
                b.append(this.myLowerBound.getPrefix().getValue());
            }
            b.append(this.myLowerBound.getValueAsString());
        }
        if (this.hasBound(this.myUpperBound)) {
            if (this.hasBound(this.myLowerBound)) {
                b.append(" ");
            }
            if (this.myUpperBound.getPrefix() != null) {
                b.append(this.myUpperBound.getPrefix().getValue());
            }
            b.append(this.myUpperBound.getValueAsString());
        } else if (!this.hasBound(this.myLowerBound)) {
            b.append("empty");
        }
        b.append("]");
        return b.toString();
    }

    private void validateAndSet(DateParam lowerBound, DateParam upperBound) {
        if (this.hasBound(lowerBound) && this.hasBound(upperBound) && lowerBound.getValue().getTime() > upperBound.getValue().getTime()) {
            throw new DataFormatException(String.format("Lower bound of %s is after upper bound of %s", lowerBound.getValueAsString(), upperBound.getValueAsString()));
        }
        if (this.hasBound(lowerBound)) {
            if (lowerBound.getPrefix() == null) {
                lowerBound.setPrefix(ParamPrefixEnum.GREATERTHAN_OR_EQUALS);
            }
            switch (lowerBound.getPrefix()) {
                default: {
                    break;
                }
                case LESSTHAN: 
                case LESSTHAN_OR_EQUALS: {
                    throw new DataFormatException("Lower bound comparator must be > or >=, can not be " + lowerBound.getPrefix().getValue());
                }
            }
        }
        if (this.hasBound(upperBound)) {
            if (upperBound.getPrefix() == null) {
                upperBound.setPrefix(ParamPrefixEnum.LESSTHAN_OR_EQUALS);
            }
            switch (upperBound.getPrefix()) {
                default: {
                    break;
                }
                case GREATERTHAN: 
                case GREATERTHAN_OR_EQUALS: {
                    throw new DataFormatException("Upper bound comparator must be < or <=, can not be " + upperBound.getPrefix().getValue());
                }
            }
        }
        this.myLowerBound = lowerBound;
        this.myUpperBound = upperBound;
    }
}

