/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseParam
implements IQueryParameterType {
    private Boolean myMissing;

    abstract String doGetQueryParameterQualifier();

    abstract String doGetValueAsQueryToken(FhirContext var1);

    abstract void doSetValueAsQueryToken(FhirContext var1, String var2, String var3, String var4);

    @Override
    public Boolean getMissing() {
        return this.myMissing;
    }

    @Override
    public final String getQueryParameterQualifier() {
        if (this.myMissing != null) {
            return ":missing";
        }
        return this.doGetQueryParameterQualifier();
    }

    @Override
    public final String getValueAsQueryToken(FhirContext theContext) {
        if (this.myMissing != null) {
            return this.myMissing != false ? "true" : "false";
        }
        return this.doGetValueAsQueryToken(theContext);
    }

    protected boolean isSupportsChain() {
        return false;
    }

    @Override
    public BaseParam setMissing(Boolean theMissing) {
        this.myMissing = theMissing;
        return this;
    }

    @Override
    public final void setValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        if (":missing".equals(theQualifier)) {
            this.myMissing = "true".equals(theValue);
            this.doSetValueAsQueryToken(theContext, theParamName, null, null);
        } else {
            if (StringUtils.isNotBlank((CharSequence)theQualifier) && theQualifier.charAt(0) == '.' && !this.isSupportsChain()) {
                String msg = theContext.getLocalizer().getMessage(BaseParam.class, "chainNotSupported", theParamName + theQualifier, theQualifier);
                throw new InvalidRequestException(msg);
            }
            this.myMissing = null;
            this.doSetValueAsQueryToken(theContext, theParamName, theQualifier, theValue);
        }
    }
}

