/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec.table;

import ca.carleton.gcrc.dbSec.OperationAccess;
import ca.carleton.gcrc.dbSec.RecordSelector;
import ca.carleton.gcrc.dbSec.RecordSelectorComparison;
import ca.carleton.gcrc.dbSec.impl.TableSchemaImpl;
import ca.carleton.gcrc.dbSec.table.OperationAccessAllowed;
import ca.carleton.gcrc.dbSec.table.OperationAccessDisallowed;
import ca.carleton.gcrc.dbSec.table.OperationAccessPartial;
import ca.carleton.gcrc.json.JSONSupport;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TableOptionsParser {
    public static void parseTableOptions(String optionsString, TableSchemaImpl tableSchema) throws Exception {
        if (null == optionsString) {
            return;
        }
        JSONObject jsonObj = null;
        try {
            JSONTokener jsonTokener = new JSONTokener("{" + optionsString + "}");
            Object obj = jsonTokener.nextValue();
            if (!(obj instanceof JSONObject)) {
                throw new Exception("Unexpected returned object type: " + obj.getClass().getSimpleName());
            }
            jsonObj = (JSONObject)obj;
        }
        catch (Exception e) {
            throw new Exception("Error while parsing table options: " + optionsString, e);
        }
        OperationAccess access = TableOptionsParser.parseOption(jsonObj, Option.QUERY, tableSchema);
        tableSchema.setQueryAccess(access);
        access = TableOptionsParser.parseOption(jsonObj, Option.INSERT, tableSchema);
        if (access.isAllowed() && access.getWhereClauses().size() > 0) {
            throw new Exception("Selection is not allowed on insert");
        }
        tableSchema.setInsertAccess(access);
        access = TableOptionsParser.parseOption(jsonObj, Option.UPDATE, tableSchema);
        tableSchema.setUpdateAccess(access);
        access = TableOptionsParser.parseOption(jsonObj, Option.DELETE, tableSchema);
        tableSchema.setDeleteAccess(access);
    }

    public static OperationAccess parseOption(JSONObject jsonObj, Option option, TableSchemaImpl tableSchema) throws Exception {
        if (!JSONSupport.containsKey((JSONObject)jsonObj, (String)option.getJsonLabel())) {
            return OperationAccessDisallowed.instance;
        }
        Object value = jsonObj.get(option.getJsonLabel());
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            if (b.booleanValue()) {
                return OperationAccessAllowed.instance;
            }
            return OperationAccessDisallowed.instance;
        }
        if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            if (0 == array.length()) {
                return OperationAccessDisallowed.instance;
            }
            List<RecordSelector> columnComparisons = RecordSelectorComparison.columnComparisonsFromJson(array, null);
            OperationAccessPartial access = new OperationAccessPartial();
            access.setWhereClauses(columnComparisons);
            return access;
        }
        return OperationAccessDisallowed.instance;
    }

    private static enum Option {
        QUERY("query"),
        INSERT("insert"),
        UPDATE("update"),
        DELETE("delete");

        private String jsonLabel;

        private Option(String jsonLabel) {
            this.jsonLabel = jsonLabel;
        }

        public String getJsonLabel() {
            return this.jsonLabel;
        }
    }
}

