/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec.impl;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.OperationAccess;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.impl.ColumnDataImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONObject;

public class TableSchemaImpl
implements TableSchema {
    private String logicalName;
    private String physicalName;
    private int groupId;
    private OperationAccess queryAccess;
    private OperationAccess insertAccess;
    private OperationAccess updateAccess;
    private OperationAccess deleteAccess;
    private Map<String, ColumnDataImpl> columnMap = new HashMap<String, ColumnDataImpl>();

    @Override
    public String getLogicalName() {
        return this.logicalName;
    }

    public void setLogicalName(String tableName) {
        this.logicalName = tableName;
    }

    @Override
    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String viewName) {
        this.physicalName = viewName;
    }

    @Override
    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    @Override
    public OperationAccess getQueryAccess() {
        return this.queryAccess;
    }

    public void setQueryAccess(OperationAccess queryAccess) {
        this.queryAccess = queryAccess;
    }

    @Override
    public OperationAccess getInsertAccess() {
        return this.insertAccess;
    }

    public void setInsertAccess(OperationAccess insertAccess) {
        this.insertAccess = insertAccess;
    }

    @Override
    public OperationAccess getUpdateAccess() {
        return this.updateAccess;
    }

    public void setUpdateAccess(OperationAccess updateAccess) {
        this.updateAccess = updateAccess;
    }

    @Override
    public OperationAccess getDeleteAccess() {
        return this.deleteAccess;
    }

    public void setDeleteAccess(OperationAccess deleteAccess) {
        this.deleteAccess = deleteAccess;
    }

    @Override
    public List<ColumnData> getColumns() {
        Vector<ColumnData> result = new Vector<ColumnData>();
        result.addAll(this.columnMap.values());
        return result;
    }

    @Override
    public ColumnData getColumnFromName(String columnName) {
        return this.columnMap.get(columnName);
    }

    public ColumnDataImpl createColumnDataFromName(String columnName) {
        ColumnDataImpl columnData = this.columnMap.get(columnName);
        if (null == columnData) {
            columnData = new ColumnDataImpl();
            columnData.setColumnName(columnName);
            this.columnMap.put(columnName, columnData);
        }
        return columnData;
    }

    @Override
    public JSONObject toJSON() throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("table", (Object)this.logicalName);
        obj.put("isQueryAllowed", this.queryAccess.isAllowed());
        obj.put("isInsertAllowed", this.insertAccess.isAllowed());
        obj.put("isUpdateAllowed", this.updateAccess.isAllowed());
        obj.put("isDeleteAllowed", this.deleteAccess.isAllowed());
        JSONArray array = new JSONArray();
        for (ColumnData columnData : this.getColumns()) {
            if (!columnData.isReadable()) continue;
            JSONObject col = columnData.toJSON();
            array.put((Object)col);
        }
        obj.put("columns", (Object)array);
        return obj;
    }
}

