/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec.impl;

import ca.carleton.gcrc.dbSec.RecordSelector;
import ca.carleton.gcrc.dbSec.RecordSelectorComparison;
import ca.carleton.gcrc.dbSec.impl.ColumnDataImpl;
import ca.carleton.gcrc.json.JSONSupport;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ColumnOptionsParser {
    public static void parseColumnOptions(String optionsString, ColumnDataImpl columnData) throws Exception {
        if (null == optionsString) {
            return;
        }
        JSONObject jsonObj = null;
        try {
            JSONTokener jsonTokener = new JSONTokener("{" + optionsString + "}");
            Object obj = jsonTokener.nextValue();
            if (!(obj instanceof JSONObject)) {
                throw new Exception("Unexpected returned object type: " + obj.getClass().getSimpleName());
            }
            jsonObj = (JSONObject)obj;
        }
        catch (Exception e) {
            throw new Exception("Error while parsing column options: " + optionsString, e);
        }
        ColumnOptionsParser.parseWhereOptions(jsonObj, columnData);
        ColumnOptionsParser.parseOnInsertOptions(jsonObj, columnData);
    }

    private static void parseWhereOptions(JSONObject jsonObj, ColumnDataImpl columnData) throws Exception {
        if (null == jsonObj) {
            return;
        }
        if (!JSONSupport.containsKey((JSONObject)jsonObj, (String)"where")) {
            return;
        }
        try {
            JSONArray whereArray = jsonObj.getJSONArray("where");
            List<RecordSelector> columnComparisons = RecordSelectorComparison.columnComparisonsFromJson(whereArray, columnData);
            for (RecordSelector columnComparison : columnComparisons) {
                columnData.addRowSelector(columnComparison);
            }
        }
        catch (Exception e) {
            throw new Exception("Error while parsing 'where' options: " + jsonObj.toString(), e);
        }
    }

    private static void parseOnInsertOptions(JSONObject jsonObj, ColumnDataImpl columnData) throws Exception {
        if (null == jsonObj) {
            return;
        }
        if (!JSONSupport.containsKey((JSONObject)jsonObj, (String)"onInsert")) {
            return;
        }
        try {
            String value;
            JSONObject onInsert = jsonObj.getJSONObject("onInsert");
            if (JSONSupport.containsKey((JSONObject)onInsert, (String)"incrementInteger")) {
                String sequenceName = onInsert.getString("incrementInteger");
                columnData.setAutoIncrementSequence(sequenceName);
            }
            if (JSONSupport.containsKey((JSONObject)onInsert, (String)"assignValue")) {
                value = onInsert.get("assignValue").toString();
                columnData.setAssignValueOnInsert(value);
            }
            if (JSONSupport.containsKey((JSONObject)onInsert, (String)"assignVariable")) {
                value = onInsert.get("assignVariable").toString();
                columnData.setAssignVariableOnInsert(value);
            }
        }
        catch (Exception e) {
            throw new Exception("Error while parsing 'onInsert' options: " + jsonObj.toString(), e);
        }
    }
}

