/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec.impl;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.RecordSelector;
import java.util.List;
import java.util.Vector;
import org.json.JSONObject;

public class ColumnDataImpl
implements ColumnData {
    private String columnName;
    private ColumnData.Type columnType = ColumnData.Type.UNKNOWN;
    private boolean readable = true;
    private boolean writeable = true;
    private String autoIncrementSequence = null;
    private String assignValueOnInsert = null;
    private String assignVariableOnInsert = null;
    private List<RecordSelector> rowSelectors;
    private String geomSrid = "4326";

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public ColumnData.Type getColumnType() {
        return this.columnType;
    }

    public void setColumnType(ColumnData.Type columnType) {
        this.columnType = columnType;
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    @Override
    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    @Override
    public boolean isAutoIncrementInteger() {
        return null != this.autoIncrementSequence;
    }

    @Override
    public String getAutoIncrementSequence() throws Exception {
        if (null == this.autoIncrementSequence) {
            throw new Exception("No auto increment sequence specified for column " + this.columnName);
        }
        return this.autoIncrementSequence;
    }

    @Override
    public void setAutoIncrementSequence(String autoIncrementSequence) {
        this.autoIncrementSequence = autoIncrementSequence;
    }

    @Override
    public String getAssignValueOnInsert() {
        return this.assignValueOnInsert;
    }

    public void setAssignValueOnInsert(String value) {
        this.assignValueOnInsert = value;
    }

    @Override
    public String getAssignVariableOnInsert() {
        return this.assignVariableOnInsert;
    }

    public void setAssignVariableOnInsert(String variable) {
        this.assignVariableOnInsert = variable;
    }

    @Override
    public List<RecordSelector> getRowSelectors() {
        return this.rowSelectors;
    }

    public void setRowSelectors(List<RecordSelector> rowSelectors) {
        this.rowSelectors = rowSelectors;
    }

    public void addRowSelector(RecordSelector rowSelector) {
        if (null == this.rowSelectors) {
            this.rowSelectors = new Vector<RecordSelector>();
        }
        this.rowSelectors.add(rowSelector);
    }

    @Override
    public JSONObject toJSON() throws Exception {
        JSONObject obj = new JSONObject();
        obj.put("column", (Object)this.columnName);
        obj.put("read", this.readable);
        obj.put("write", this.writeable);
        obj.put("type", (Object)this.columnType.toString());
        return obj;
    }

    @Override
    public String getQuerySelector() throws Exception {
        if (ColumnData.Type.DOUBLE == this.columnType) {
            return this.columnName;
        }
        if (ColumnData.Type.INTEGER == this.columnType) {
            return this.columnName;
        }
        if (ColumnData.Type.BIGINT == this.columnType) {
            return this.columnName;
        }
        if (ColumnData.Type.STRING == this.columnType) {
            return this.columnName;
        }
        if (ColumnData.Type.TIME == this.columnType) {
            return this.columnName;
        }
        if (ColumnData.Type.TIMESTAMP == this.columnType) {
            return this.columnName;
        }
        if (ColumnData.Type.DATE == this.columnType) {
            return this.columnName;
        }
        if (ColumnData.Type.GEOMETRY == this.columnType) {
            return "AsText(" + this.columnName + ") AS " + this.columnName;
        }
        if (ColumnData.Type.BOOLEAN == this.columnType) {
            return this.columnName;
        }
        throw new Exception("Unknown query selector for type: " + (Object)((Object)this.columnType) + " (column name: " + this.columnName + ")");
    }

    @Override
    public String getWhereWildcard() throws Exception {
        if (ColumnData.Type.DOUBLE == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.INTEGER == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.BIGINT == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.STRING == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.TIME == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.TIMESTAMP == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.DATE == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.GEOMETRY == this.columnType) {
            return "GeomFromText(?," + this.geomSrid + ")";
        }
        if (ColumnData.Type.BOOLEAN == this.columnType) {
            return "?";
        }
        throw new Exception("Unknown query wildcard for type: " + (Object)((Object)this.columnType) + " (column name: " + this.columnName + ")");
    }

    @Override
    public String getInsertWildcard() throws Exception {
        if (ColumnData.Type.DOUBLE == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.INTEGER == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.BIGINT == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.STRING == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.TIME == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.TIMESTAMP == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.DATE == this.columnType) {
            return "?";
        }
        if (ColumnData.Type.GEOMETRY == this.columnType) {
            return "GeomFromText(?," + this.geomSrid + ")";
        }
        if (ColumnData.Type.BOOLEAN == this.columnType) {
            return "?";
        }
        throw new Exception("Unknown insert wildcard for type: " + (Object)((Object)this.columnType) + " (column name: " + this.columnName + ")");
    }
}

