/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.RecordSelector;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.Variables;
import ca.carleton.gcrc.dbSec.impl.SqlElement;
import ca.carleton.gcrc.dbSec.impl.TypedValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecordSelectorSearchString
implements RecordSelector {
    List<String> fieldNames = null;
    String searchedString = null;

    public RecordSelectorSearchString(List<String> fieldNames, String searchedString) {
        this.fieldNames = new ArrayList<String>(fieldNames);
        this.searchedString = searchedString;
        Collections.sort(this.fieldNames);
    }

    public RecordSelectorSearchString(String[] fieldNames, String searchedString) {
        this.fieldNames = new ArrayList<String>(fieldNames.length);
        for (String fieldName : fieldNames) {
            this.fieldNames.add(fieldName);
        }
        this.searchedString = searchedString;
        Collections.sort(this.fieldNames);
    }

    @Override
    public List<ColumnData> getColumnData(TableSchema tableSchema) throws Exception {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(this.fieldNames.size());
        for (String fieldName : this.fieldNames) {
            columnDataList.add(tableSchema.getColumnFromName(fieldName));
        }
        return columnDataList;
    }

    @Override
    public String getQueryString(TableSchema tableSchema, SqlElement.Phase phase) throws Exception {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean first = true;
        for (String fieldName : this.fieldNames) {
            if (first) {
                pw.print("(");
                first = false;
            } else {
                pw.print(" OR ");
            }
            pw.print("lower(");
            pw.print(fieldName);
            pw.print(") LIKE lower(?)");
        }
        pw.print(")");
        pw.flush();
        return sw.toString();
    }

    @Override
    public List<TypedValue> getQueryValues(TableSchema tableSchema, Variables variables) throws Exception {
        ArrayList<TypedValue> values = new ArrayList<TypedValue>(this.fieldNames.size());
        for (String fieldName : this.fieldNames) {
            ColumnData columnData = tableSchema.getColumnFromName(fieldName);
            values.add(new TypedValue(columnData.getColumnType(), "%" + this.searchedString + "%"));
        }
        return values;
    }

    @Override
    public String getComparisonString() {
        return "_search";
    }
}

