/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.Expression;
import ca.carleton.gcrc.dbSec.RecordSelector;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.Variables;
import ca.carleton.gcrc.dbSec.impl.ExpressionConstantImpl;
import ca.carleton.gcrc.dbSec.impl.ExpressionVariableImpl;
import ca.carleton.gcrc.dbSec.impl.SqlElement;
import ca.carleton.gcrc.dbSec.impl.TypedValue;
import ca.carleton.gcrc.json.JSONSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class RecordSelectorComparison
implements RecordSelector {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private String columnName;
    private Comparison comparison;
    private Expression expression;

    public static List<RecordSelector> columnComparisonsFromJson(JSONArray array, ColumnData columnData) throws Exception {
        Vector<RecordSelector> columnComparisons = new Vector<RecordSelector>();
        for (int loop = 0; loop < array.length(); ++loop) {
            JSONObject jsonComparison = array.getJSONObject(loop);
            RecordSelector whereClause = RecordSelectorComparison.columnComparisonFromJson(jsonComparison, columnData);
            columnComparisons.add(whereClause);
        }
        return columnComparisons;
    }

    public static RecordSelector columnComparisonFromJson(JSONObject jsonComparison, ColumnData columnData) throws Exception {
        String valueString;
        String columnName = null;
        if (null != columnData) {
            columnName = columnData.getColumnName();
        } else if (JSONSupport.containsKey((JSONObject)jsonComparison, (String)"column")) {
            columnName = jsonComparison.getString("column");
        } else {
            throw new Exception("Column name required");
        }
        Expression expression = null;
        if (JSONSupport.containsKey((JSONObject)jsonComparison, (String)"value")) {
            valueString = jsonComparison.get("value").toString();
            expression = new ExpressionConstantImpl(valueString);
        }
        if (JSONSupport.containsKey((JSONObject)jsonComparison, (String)"variable")) {
            valueString = jsonComparison.get("variable").toString();
            expression = new ExpressionVariableImpl(valueString);
        }
        String comparisonName = jsonComparison.getString("comparison");
        Comparison selectedComparison = null;
        for (Comparison comparison : Comparison.values()) {
            if (!comparison.name().equals(comparisonName)) continue;
            selectedComparison = comparison;
            break;
        }
        if (null == selectedComparison) {
            throw new Exception("Unknown comparison: " + comparisonName);
        }
        if (selectedComparison.requiresValue() && null == expression) {
            throw new Exception("Expression required (value or variable) for comparison: " + selectedComparison.name());
        }
        RecordSelectorComparison comparison = new RecordSelectorComparison(columnName, selectedComparison, expression);
        return comparison;
    }

    public RecordSelectorComparison(String columnName, Comparison comparison, Expression expression) {
        this.columnName = columnName;
        this.comparison = comparison;
        this.expression = expression;
    }

    public RecordSelectorComparison(String columnName, Comparison comparison, String constantExpression) {
        this.columnName = columnName;
        this.comparison = comparison;
        this.expression = new ExpressionConstantImpl(constantExpression);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public Comparison getComparison() {
        return this.comparison;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public String getQueryString(TableSchema tableSchema, SqlElement.Phase phase) throws Exception {
        return "(" + this.columnName + " " + this.getSqlExpression() + ")";
    }

    private String getSqlExpression() throws Exception {
        if (Comparison.EQUAL == this.comparison) {
            return " = ?";
        }
        if (Comparison.NOT_EQUAL == this.comparison) {
            return " <> ?";
        }
        if (Comparison.GREATER_THAN == this.comparison) {
            return " > ?";
        }
        if (Comparison.GREATER_THAN_OR_EQUAL == this.comparison) {
            return " >= ?";
        }
        if (Comparison.LESS_THAN == this.comparison) {
            return " < ?";
        }
        if (Comparison.LESS_THAN_OR_EQUAL == this.comparison) {
            return " <= ?";
        }
        if (Comparison.IS_NULL == this.comparison) {
            return " IS NULL";
        }
        if (Comparison.IS_NOT_NULL == this.comparison) {
            return " IS NOT NULL";
        }
        throw new Exception("Can not compute SQL expression for: " + (Object)((Object)this.comparison));
    }

    @Override
    public List<ColumnData> getColumnData(TableSchema tableSchema) throws Exception {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(1);
        columnDataList.add(tableSchema.getColumnFromName(this.columnName));
        return columnDataList;
    }

    @Override
    public List<TypedValue> getQueryValues(TableSchema tableSchema, Variables variables) throws Exception {
        Vector<TypedValue> values = new Vector<TypedValue>();
        if (this.comparison.requiresValue()) {
            String value = this.expression.getValue(variables);
            ColumnData columnData = tableSchema.getColumnFromName(this.columnName);
            values.add(new TypedValue(columnData.getColumnType(), value));
        }
        return values;
    }

    @Override
    public String getComparisonString() {
        return this.columnName + "|" + this.comparison.name();
    }

    public String toString() {
        return this.comparison.name() + "(" + this.columnName + ")" + this.expression;
    }

    public static enum Comparison {
        EQUAL(true),
        NOT_EQUAL(true),
        GREATER_THAN_OR_EQUAL(true),
        LESS_THAN_OR_EQUAL(true),
        GREATER_THAN(true),
        LESS_THAN(true),
        IS_NULL(false),
        IS_NOT_NULL(false);

        private boolean fRequiresValue;

        private Comparison(boolean fRequiresValue) {
            this.fRequiresValue = fRequiresValue;
        }

        public boolean requiresValue() {
            return this.fRequiresValue;
        }
    }
}

