/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.FieldSelector;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.Variables;
import ca.carleton.gcrc.dbSec.impl.SqlElement;
import ca.carleton.gcrc.dbSec.impl.TypedValue;
import java.util.List;

public class OrderSpecifier
implements SqlElement {
    private Type type;
    private FieldSelector fieldSelector;

    public OrderSpecifier(Type type, FieldSelector fieldSelector) {
        this.type = type;
        this.fieldSelector = fieldSelector;
    }

    @Override
    public List<ColumnData> getColumnData(TableSchema tableSchema) throws Exception {
        return this.fieldSelector.getColumnData(tableSchema);
    }

    @Override
    public String getQueryString(TableSchema tableSchema, SqlElement.Phase phase) throws Exception {
        String fieldExpression = this.fieldSelector.getQueryString(tableSchema, phase);
        if (Type.ASCENDING == this.type) {
            fieldExpression = fieldExpression + " ASC";
        } else if (Type.DESCENDING == this.type) {
            fieldExpression = fieldExpression + " DESC";
        } else {
            throw new Exception("Unknown ORDER BY type: " + (Object)((Object)this.type));
        }
        return fieldExpression;
    }

    @Override
    public List<TypedValue> getQueryValues(TableSchema tableSchema, Variables variables) throws Exception {
        return this.fieldSelector.getQueryValues(tableSchema, variables);
    }

    public String toString() {
        return "order_by_" + this.fieldSelector.toString() + "_" + (Object)((Object)this.type);
    }

    public static enum Type {
        ASCENDING,
        DESCENDING;

    }
}

