/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.FieldSelector;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.Variables;
import ca.carleton.gcrc.dbSec.impl.SqlElement;
import ca.carleton.gcrc.dbSec.impl.TypedValue;
import java.util.ArrayList;
import java.util.List;

public class FieldSelectorFunction
implements FieldSelector {
    private Type functionType;
    private String columnName;

    public FieldSelectorFunction(Type functionType, String columnName) {
        this.functionType = functionType;
        this.columnName = columnName;
    }

    public Type getFunctionType() {
        return this.functionType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getQueryString(TableSchema tableSchema, SqlElement.Phase phase) throws Exception {
        ColumnData cData = tableSchema.getColumnFromName(this.columnName);
        if (null != cData && !cData.isReadable()) {
            cData = null;
        }
        if (null == cData) {
            throw new Exception("Select Expression column " + this.columnName + " is not available in table " + tableSchema.getLogicalName() + "(" + tableSchema.getPhysicalName() + ")");
        }
        String querySelector = String.format(this.functionType.getQueryFormat(), this.columnName);
        return querySelector;
    }

    @Override
    public List<ColumnData> getColumnData(TableSchema tableSchema) throws Exception {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(1);
        columnDataList.add(tableSchema.getColumnFromName(this.columnName));
        return columnDataList;
    }

    @Override
    public List<TypedValue> getQueryValues(TableSchema tableSchema, Variables variables) throws Exception {
        return new ArrayList<TypedValue>();
    }

    public String toString() {
        return "" + (Object)((Object)this.functionType) + "(" + this.columnName + ")";
    }

    public static enum Type {
        SUM("SUM(%1$s)"),
        MAX("MAX(%1$s)"),
        MIN("MIN(%1$s)");

        private String queryFormat;

        private Type(String queryFormat) {
            this.queryFormat = queryFormat;
        }

        public String getQueryFormat() {
            return this.queryFormat;
        }
    }
}

