/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.FieldSelector;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.Variables;
import ca.carleton.gcrc.dbSec.impl.SqlElement;
import ca.carleton.gcrc.dbSec.impl.TypedValue;
import java.util.ArrayList;
import java.util.List;

public class FieldSelectorColumn
implements FieldSelector {
    private String columnName;

    public FieldSelectorColumn(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public List<ColumnData> getColumnData(TableSchema tableSchema) throws Exception {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(1);
        columnDataList.add(tableSchema.getColumnFromName(this.columnName));
        return columnDataList;
    }

    @Override
    public String getQueryString(TableSchema tableSchema, SqlElement.Phase phase) throws Exception {
        ColumnData cData = tableSchema.getColumnFromName(this.columnName);
        if (null != cData && !cData.isReadable()) {
            cData = null;
        }
        if (null == cData) {
            throw new Exception("Select Expression column " + this.columnName + " is not available in table " + tableSchema.getLogicalName() + "(" + tableSchema.getPhysicalName() + ")");
        }
        return cData.getQuerySelector();
    }

    @Override
    public List<TypedValue> getQueryValues(TableSchema tableSchema, Variables variables) throws Exception {
        return new ArrayList<TypedValue>();
    }

    public String toString() {
        return "column(" + this.columnName + ")";
    }
}

