/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.FieldSelector;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.Variables;
import ca.carleton.gcrc.dbSec.impl.SqlElement;
import ca.carleton.gcrc.dbSec.impl.TypedValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class FieldSelectorCentroid
implements FieldSelector {
    String fieldName = null;
    Type type = null;

    public FieldSelectorCentroid(String fieldName, Type type) {
        this.fieldName = fieldName;
        this.type = type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public List<ColumnData> getColumnData(TableSchema tableSchema) throws Exception {
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>(1);
        columnDataList.add(tableSchema.getColumnFromName(this.fieldName));
        return columnDataList;
    }

    @Override
    public String getQueryString(TableSchema tableSchema, SqlElement.Phase phase) throws Exception {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (Type.X == this.type) {
            pw.print("ST_X");
        } else if (Type.Y == this.type) {
            pw.print("ST_Y");
        } else {
            throw new Exception("Can not handle type: " + (Object)((Object)this.type));
        }
        pw.print("(ST_Centroid(coalesce(ST_GeometryN(");
        pw.print(this.fieldName);
        pw.print(",1),");
        pw.print(this.fieldName);
        pw.print(")))");
        if (SqlElement.Phase.SELECT == phase) {
            if (Type.X == this.type) {
                pw.print(" AS x");
            } else if (Type.Y == this.type) {
                pw.print(" AS y");
            } else {
                throw new Exception("Can not handle type: " + (Object)((Object)this.type));
            }
        }
        pw.flush();
        return sw.toString();
    }

    @Override
    public List<TypedValue> getQueryValues(TableSchema tableSchema, Variables variables) throws Exception {
        return new ArrayList<TypedValue>();
    }

    public String toString() {
        return "_centroid(" + (Object)((Object)this.type) + "," + this.fieldName + ")";
    }

    public static enum Type {
        X,
        Y;

    }
}

