/*
 * Decompiled with CFR 0.152.
 */
package ca.carleton.gcrc.dbSec;

import ca.carleton.gcrc.dbSec.ColumnData;
import ca.carleton.gcrc.dbSec.DbUser;
import ca.carleton.gcrc.dbSec.TableSchema;
import ca.carleton.gcrc.dbSec.impl.ColumnDataImpl;
import ca.carleton.gcrc.dbSec.impl.ColumnDataUtils;
import ca.carleton.gcrc.dbSec.impl.ColumnOptionsParser;
import ca.carleton.gcrc.dbSec.impl.TableSchemaImpl;
import ca.carleton.gcrc.dbSec.table.TableOptionsParser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DbSecurity {
    private static final String DB_NAME_TABLES = "dbsec_tables";
    private static final String DB_NAME_COLUMNS = "dbsec_columns";
    private Connection connection;

    public DbSecurity(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public TableSchema getTableSchemaFromName(String tableName, DbUser user) throws Exception {
        Vector<String> tableNames = new Vector<String>();
        tableNames.add(tableName);
        Map<String, TableSchemaImpl> nameToTableMap = this.getTableDataFromGroups(user, tableNames);
        if (!nameToTableMap.containsKey(tableName)) {
            throw new Exception("A table named '" + tableName + "' does not exist or is not available");
        }
        return nameToTableMap.get(tableName);
    }

    public List<TableSchema> getAvailableTablesFromGroups(DbUser user) throws Exception {
        Map<String, TableSchemaImpl> nameToTableMap = this.getTableDataFromGroups(user, null);
        Vector<TableSchema> result = new Vector<TableSchema>();
        result.addAll(nameToTableMap.values());
        return result;
    }

    private Map<String, TableSchemaImpl> getTableDataFromGroups(DbUser user, List<String> logicalNames) throws Exception {
        HashMap<String, TableSchemaImpl> nameToTableMap = new HashMap<String, TableSchemaImpl>();
        if (null == user) {
            throw new Exception("No user supplied");
        }
        if (null != logicalNames && 0 == logicalNames.size()) {
            throw new Exception("Empty table list supplied");
        }
        List<Integer> groups = user.getGroups();
        if (null == groups || 0 == groups.size()) {
            return new HashMap<String, TableSchemaImpl>();
        }
        String sqlQuery = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("SELECT id,logical_name,physical_name,group_id,options FROM dbsec_tables WHERE (");
        boolean first = true;
        for (Integer groupId : groups) {
            if (first) {
                first = false;
            } else {
                pw.print(" OR ");
            }
            pw.print("(group_id = ");
            pw.print(groupId);
            pw.print(")");
        }
        if (null != logicalNames) {
            pw.print(") AND (");
            first = true;
            for (String logicalName : logicalNames) {
                if (first) {
                    first = false;
                } else {
                    pw.print(" OR ");
                }
                pw.print("(logical_name = '");
                pw.print(logicalName);
                pw.print("')");
            }
        }
        pw.print(") ORDER BY priority DESC;");
        pw.flush();
        sqlQuery = sw.toString();
        Statement stmt = this.connection.createStatement();
        if (stmt.execute(sqlQuery)) {
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                String logicalName = rs.getString(2);
                String physicalName = rs.getString(3);
                int groupId = rs.getInt(4);
                String options = rs.getString(5);
                TableSchemaImpl tableData = (TableSchemaImpl)nameToTableMap.get(logicalName);
                if (null != tableData) continue;
                tableData = new TableSchemaImpl();
                tableData.setLogicalName(logicalName);
                tableData.setPhysicalName(physicalName);
                tableData.setGroupId(groupId);
                try {
                    TableOptionsParser.parseTableOptions(options, tableData);
                }
                catch (Exception e) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                    throw e;
                }
                nameToTableMap.put(logicalName, tableData);
            }
        }
        stmt.close();
        this.retrieveColumnData(nameToTableMap.values());
        for (TableSchemaImpl tableData : nameToTableMap.values()) {
            this.retrieveColumnTypes(tableData);
        }
        return nameToTableMap;
    }

    private void retrieveColumnData(Collection<TableSchemaImpl> tableDataSet) throws Exception {
        for (TableSchemaImpl tableData : tableDataSet) {
            this.retrieveColumnData(tableData);
        }
    }

    private void retrieveColumnData(TableSchemaImpl tableData) throws Exception {
        String logicalName = tableData.getLogicalName();
        int groupId = tableData.getGroupId();
        try {
            PreparedStatement ps = this.connection.prepareStatement("SELECT column_name,read,write,options FROM dbsec_columns WHERE logical_name = ? AND group_id = ?");
            ps.setString(1, logicalName);
            ps.setInt(2, groupId);
            if (ps.execute()) {
                ResultSet rs = ps.getResultSet();
                while (rs.next()) {
                    String columnName = rs.getString(1);
                    boolean read = rs.getBoolean(2);
                    boolean write = rs.getBoolean(3);
                    String options = rs.getString(4);
                    ColumnDataImpl columnDataImpl = tableData.createColumnDataFromName(columnName);
                    columnDataImpl.setReadable(read);
                    columnDataImpl.setWriteable(write);
                    ColumnOptionsParser.parseColumnOptions(options, columnDataImpl);
                }
            }
            ps.close();
        }
        catch (Exception e) {
            throw new Exception("Error retrieving column data for: " + logicalName + "/" + groupId, e);
        }
    }

    private void retrieveColumnTypes(TableSchemaImpl tableData) throws Exception {
        String sqlQuery = null;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print("SELECT * FROM ");
        pw.print(tableData.getPhysicalName());
        pw.print(" LIMIT 1;");
        pw.flush();
        sqlQuery = sw.toString();
        Statement stmt = this.connection.createStatement();
        if (stmt.execute(sqlQuery)) {
            ResultSet rs = stmt.getResultSet();
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            for (int loop = 0; loop < count; ++loop) {
                String columnName = rsmd.getColumnName(loop + 1);
                int sqlType = rsmd.getColumnType(loop + 1);
                String sqlTypeName = rsmd.getColumnTypeName(loop + 1);
                ColumnDataImpl columnDataImpl = tableData.createColumnDataFromName(columnName);
                ColumnData.Type colType = ColumnDataUtils.columnDataTypeFromSQLType(sqlType, columnName, sqlTypeName);
                columnDataImpl.setColumnType(colType);
            }
        }
    }
}

