/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0006"}, d2={"Lau/com/dius/pact/provider/HttpClientFactory;", "Lau/com/dius/pact/provider/IHttpClientFactory;", "()V", "createInsecure", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "createWithTrustStore", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "newClient"})
public final class HttpClientFactory
implements IHttpClientFactory {
    @Override
    @NotNull
    public CloseableHttpClient newClient(@NotNull IProviderInfo provider) {
        CloseableHttpClient closeableHttpClient;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        if (provider.getCreateClient() != null) {
            if (provider.getCreateClient() instanceof Closure) {
                Object object = provider.getCreateClient();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type groovy.lang.Closure<*>");
                Object object2 = ((Closure)object).call((Object)provider);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.apache.hc.client5.http.impl.classic.CloseableHttpClient");
                closeableHttpClient = (CloseableHttpClient)object2;
            } else {
                Binding binding = new Binding();
                binding.setVariable("provider", (Object)provider);
                GroovyShell shell = new GroovyShell(binding);
                Object object = shell.evaluate(String.valueOf(provider.getCreateClient()));
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.hc.client5.http.impl.classic.CloseableHttpClient");
                closeableHttpClient = (CloseableHttpClient)object;
            }
        } else if (provider.getInsecure()) {
            closeableHttpClient = this.createInsecure();
        } else if (provider.getTrustStore() != null && provider.getTrustStorePassword() != null) {
            closeableHttpClient = this.createWithTrustStore(provider);
        } else {
            HttpClientBuilder builder = HttpClients.custom().useSystemProperties();
            String enableRedirectHandling = System.getProperty("pact.verifier.enableRedirectHandling");
            CharSequence charSequence = enableRedirectHandling;
            if (charSequence == null || charSequence.length() == 0 || !Intrinsics.areEqual((Object)enableRedirectHandling, (Object)"true")) {
                builder.disableRedirectHandling();
            }
            CloseableHttpClient closeableHttpClient2 = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient2, (String)"{\n      val builder = Ht\u2026    builder.build()\n    }");
            closeableHttpClient = closeableHttpClient2;
        }
        return closeableHttpClient;
    }

    private final CloseableHttpClient createWithTrustStore(IProviderInfo provider) {
        String string = provider.getTrustStorePassword();
        if (string == null) {
            string = "";
        }
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] password = cArray;
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(provider.getTrustStore(), password).build();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        HttpClientBuilder builder = HttpClients.custom().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connManager);
        String enableRedirectHandling = System.getProperty("pact.verifier.enableRedirectHandling");
        CharSequence charSequence = enableRedirectHandling;
        if (charSequence == null || charSequence.length() == 0 || !Intrinsics.areEqual((Object)enableRedirectHandling, (Object)"true")) {
            builder.disableRedirectHandling();
        }
        CloseableHttpClient closeableHttpClient = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"builder.build()");
        return closeableHttpClient;
    }

    private final CloseableHttpClient createInsecure() {
        HttpClientBuilder b = HttpClientBuilder.create().useSystemProperties();
        String enableRedirectHandling = System.getProperty("pact.verifier.enableRedirectHandling");
        CharSequence charSequence = enableRedirectHandling;
        if (charSequence == null || charSequence.length() == 0 || !Intrinsics.areEqual((Object)enableRedirectHandling, (Object)"true")) {
            b.disableRedirectHandling();
        }
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
        NoopHostnameVerifier hostnameVerifier = new NoopHostnameVerifier();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        b.setConnectionManager((HttpClientConnectionManager)connMgr);
        CloseableHttpClient closeableHttpClient = b.build();
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"b.build()");
        return closeableHttpClient;
    }
}

