/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.org.fusesource.jansi;

import au.com.dius.pact.provider.org.fusesource.jansi.Ansi;
import java.util.Locale;
import org.fusesource.jansi.Ansi;

public class AnsiRenderer {
    public static final String BEGIN_TOKEN = "@|";
    private static final int BEGIN_TOKEN_LEN = 2;
    public static final String END_TOKEN = "|@";
    private static final int END_TOKEN_LEN = 2;
    public static final String CODE_TEXT_SEPARATOR = " ";
    public static final String CODE_LIST_SEPARATOR = ",";

    private AnsiRenderer() {
    }

    public static String render(String input) throws IllegalArgumentException {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (true) {
            int j;
            if ((j = input.indexOf(BEGIN_TOKEN, i)) == -1) {
                if (i == 0) {
                    return input;
                }
                buff.append(input.substring(i, input.length()));
                return buff.toString();
            }
            buff.append(input.substring(i, j));
            int k = input.indexOf(END_TOKEN, j);
            if (k == -1) {
                return input;
            }
            String spec = input.substring(j += 2, k);
            String[] items = spec.split(CODE_TEXT_SEPARATOR, 2);
            if (items.length == 1) {
                return input;
            }
            String replacement = AnsiRenderer.render(items[1], items[0].split(CODE_LIST_SEPARATOR));
            buff.append(replacement);
            i = k + 2;
        }
    }

    private static String render(String text, String ... codes) {
        Ansi ansi = Ansi.ansi();
        for (String name : codes) {
            Code code = Code.valueOf(name.toUpperCase(Locale.ENGLISH));
            if (code.isColor()) {
                if (code.isBackground()) {
                    ansi = ansi.bg(code.getColor());
                    continue;
                }
                ansi = ansi.fg(code.getColor());
                continue;
            }
            if (!code.isAttribute()) continue;
            ansi = ansi.a(code.getAttribute());
        }
        return ansi.a(text).reset().toString();
    }

    public static boolean test(String text) {
        return text != null && text.contains(BEGIN_TOKEN);
    }

    public static enum Code {
        BLACK((Enum)Ansi.Color.BLACK),
        RED((Enum)Ansi.Color.RED),
        GREEN((Enum)Ansi.Color.GREEN),
        YELLOW((Enum)Ansi.Color.YELLOW),
        BLUE((Enum)Ansi.Color.BLUE),
        MAGENTA((Enum)Ansi.Color.MAGENTA),
        CYAN((Enum)Ansi.Color.CYAN),
        WHITE((Enum)Ansi.Color.WHITE),
        FG_BLACK((Enum)Ansi.Color.BLACK, false),
        FG_RED((Enum)Ansi.Color.RED, false),
        FG_GREEN((Enum)Ansi.Color.GREEN, false),
        FG_YELLOW((Enum)Ansi.Color.YELLOW, false),
        FG_BLUE((Enum)Ansi.Color.BLUE, false),
        FG_MAGENTA((Enum)Ansi.Color.MAGENTA, false),
        FG_CYAN((Enum)Ansi.Color.CYAN, false),
        FG_WHITE((Enum)Ansi.Color.WHITE, false),
        BG_BLACK((Enum)Ansi.Color.BLACK, true),
        BG_RED((Enum)Ansi.Color.RED, true),
        BG_GREEN((Enum)Ansi.Color.GREEN, true),
        BG_YELLOW((Enum)Ansi.Color.YELLOW, true),
        BG_BLUE((Enum)Ansi.Color.BLUE, true),
        BG_MAGENTA((Enum)Ansi.Color.MAGENTA, true),
        BG_CYAN((Enum)Ansi.Color.CYAN, true),
        BG_WHITE((Enum)Ansi.Color.WHITE, true),
        RESET((Enum)Ansi.Attribute.RESET),
        INTENSITY_BOLD((Enum)Ansi.Attribute.INTENSITY_BOLD),
        INTENSITY_FAINT((Enum)Ansi.Attribute.INTENSITY_FAINT),
        ITALIC((Enum)Ansi.Attribute.ITALIC),
        UNDERLINE((Enum)Ansi.Attribute.UNDERLINE),
        BLINK_SLOW((Enum)Ansi.Attribute.BLINK_SLOW),
        BLINK_FAST((Enum)Ansi.Attribute.BLINK_FAST),
        BLINK_OFF((Enum)Ansi.Attribute.BLINK_OFF),
        NEGATIVE_ON((Enum)Ansi.Attribute.NEGATIVE_ON),
        NEGATIVE_OFF((Enum)Ansi.Attribute.NEGATIVE_OFF),
        CONCEAL_ON((Enum)Ansi.Attribute.CONCEAL_ON),
        CONCEAL_OFF((Enum)Ansi.Attribute.CONCEAL_OFF),
        UNDERLINE_DOUBLE((Enum)Ansi.Attribute.UNDERLINE_DOUBLE),
        UNDERLINE_OFF((Enum)Ansi.Attribute.UNDERLINE_OFF),
        BOLD((Enum)Ansi.Attribute.INTENSITY_BOLD),
        FAINT((Enum)Ansi.Attribute.INTENSITY_FAINT);

        private final Enum n;
        private final boolean background;

        private Code(Enum n2, boolean background) {
            this.n = n2;
            this.background = background;
        }

        private Code(Enum n2) {
            this(n2, false);
        }

        public boolean isColor() {
            return this.n instanceof Ansi.Color;
        }

        public Ansi.Color getColor() {
            return (Ansi.Color)this.n;
        }

        public boolean isAttribute() {
            return this.n instanceof Ansi.Attribute;
        }

        public Ansi.Attribute getAttribute() {
            return (Ansi.Attribute)this.n;
        }

        public boolean isBackground() {
            return this.background;
        }
    }
}

