/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.org.fusesource.jansi;

import au.com.dius.pact.provider.org.fusesource.jansi.AnsiOutputStream;
import au.com.dius.pact.provider.org.fusesource.jansi.WindowsAnsiOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.fusesource.jansi.internal.CLibrary;

public class AnsiConsole {
    public static final PrintStream system_out;
    public static final PrintStream out;
    public static final PrintStream system_err;
    public static final PrintStream err;
    private static int installed;

    private AnsiConsole() {
    }

    public static OutputStream wrapOutputStream(OutputStream stream) {
        return AnsiConsole.wrapOutputStream(stream, CLibrary.STDOUT_FILENO);
    }

    public static OutputStream wrapOutputStream(OutputStream stream, int fileno) {
        if (Boolean.getBoolean("jansi.passthrough")) {
            return stream;
        }
        if (Boolean.getBoolean("jansi.strip")) {
            return new AnsiOutputStream(stream);
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows") && !AnsiConsole.isXterm()) {
            try {
                return new WindowsAnsiOutputStream(stream);
            }
            catch (Throwable throwable) {
                return new AnsiOutputStream(stream);
            }
        }
        try {
            boolean forceColored = Boolean.getBoolean("jansi.force");
            int rc = CLibrary.isatty((int)fileno);
            if (!AnsiConsole.isXterm() && !forceColored && rc == 0) {
                return new AnsiOutputStream(stream);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return new FilterOutputStream(stream){

            @Override
            public void close() throws IOException {
                this.write(AnsiOutputStream.REST_CODE);
                this.flush();
                super.close();
            }
        };
    }

    private static boolean isXterm() {
        return "xterm".equals(System.getenv("TERM"));
    }

    public static PrintStream out() {
        return out;
    }

    public static PrintStream err() {
        return err;
    }

    public static synchronized void systemInstall() {
        if (++installed == 1) {
            System.setOut(out);
            System.setErr(err);
        }
    }

    public static synchronized void systemUninstall() {
        if (--installed == 0) {
            System.setOut(system_out);
            System.setErr(system_err);
        }
    }

    static {
        PrintStream jansiErr;
        PrintStream jansiOut;
        system_out = System.out;
        system_err = System.err;
        try {
            jansiOut = new PrintStream(AnsiConsole.wrapOutputStream(system_out));
            jansiErr = new PrintStream(AnsiConsole.wrapOutputStream(system_err, CLibrary.STDERR_FILENO));
        }
        catch (UnsatisfiedLinkError e) {
            jansiOut = system_out;
            jansiErr = system_err;
        }
        out = jansiOut;
        err = jansiErr;
    }
}

