/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileChangeEvent;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class DelegateFileObject
extends AbstractFileObject
implements FileListener {
    private FileObject file;
    private final Set children = new HashSet();
    private boolean ignoreEvent;

    public DelegateFileObject(FileName name, AbstractFileSystem fileSystem, FileObject file) throws FileSystemException {
        super(name, fileSystem);
        this.file = file;
        if (file != null) {
            file.getFileSystem().addListener(file, this);
        }
    }

    public void attachChild(String baseName) throws Exception {
        FileType oldType = this.doGetType();
        if (this.children.add(baseName)) {
            this.childrenChanged();
        }
        this.maybeTypeChanged(oldType);
    }

    public void setFile(FileObject file) throws Exception {
        FileType oldType = this.doGetType();
        if (file != null) {
            file.getFileSystem().addListener(file, this);
        }
        this.file = file;
        this.maybeTypeChanged(oldType);
    }

    private void maybeTypeChanged(FileType oldType) throws Exception {
        FileType newType = this.doGetType();
        if (oldType == FileType.IMAGINARY && newType != FileType.IMAGINARY) {
            this.handleCreate(newType);
        } else if (oldType != FileType.IMAGINARY && newType == FileType.IMAGINARY) {
            this.handleDelete();
        }
    }

    protected FileType doGetType() throws FileSystemException {
        if (this.file != null) {
            return this.file.getType();
        }
        if (this.children.size() > 0) {
            return FileType.FOLDER;
        }
        return FileType.IMAGINARY;
    }

    protected boolean doIsReadable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isReadable();
        }
        return true;
    }

    protected boolean doIsWriteable() throws FileSystemException {
        if (this.file != null) {
            return this.file.isWriteable();
        }
        return false;
    }

    protected boolean doIsHidden() throws FileSystemException {
        if (this.file != null) {
            return this.file.isHidden();
        }
        return false;
    }

    protected String[] doListChildren() throws Exception {
        if (this.file != null) {
            FileObject[] children = this.file.getChildren();
            String[] childNames = new String[children.length];
            for (int i = 0; i < children.length; ++i) {
                childNames[i] = children[i].getName().getBaseName();
            }
            return childNames;
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreateFolder() throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.createFolder();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete() throws Exception {
        this.ignoreEvent = true;
        try {
            this.file.delete();
        }
        finally {
            this.ignoreEvent = false;
        }
    }

    protected long doGetContentSize() throws Exception {
        return this.file.getContent().getSize();
    }

    protected Map doGetAttributes() throws Exception {
        return this.file.getContent().getAttributes();
    }

    protected void doSetAttribute(String atttrName, Object value) throws Exception {
        this.file.getContent().setAttribute(atttrName, value);
    }

    protected Certificate[] doGetCertificates() throws Exception {
        return this.file.getContent().getCertificates();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.getContent().getLastModifiedTime();
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
        this.file.getContent().setLastModifiedTime(modtime);
    }

    protected InputStream doGetInputStream() throws Exception {
        return this.file.getContent().getInputStream();
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return this.file.getContent().getOutputStream(bAppend);
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        if (!this.ignoreEvent) {
            this.handleCreate(this.file.getType());
        }
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        if (!this.ignoreEvent) {
            this.handleDelete();
        }
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        if (!this.ignoreEvent) {
            this.handleChanged();
        }
    }
}

