/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.net.URL;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.UriParser;

public class BasicFileName
extends AbstractFileName {
    private final String rootUri;

    public BasicFileName(String rootUri, String path) {
        this(UriParser.extractScheme(rootUri), rootUri, path, false);
    }

    public BasicFileName(String scheme, String rootUri, String path) {
        this(scheme, rootUri, path, false);
    }

    private BasicFileName(String scheme, String rootUri, String path, boolean normalised) {
        super(scheme, path);
        this.rootUri = !normalised && rootUri.endsWith("/") ? rootUri.substring(0, rootUri.length() - 1) : rootUri;
    }

    public BasicFileName(FileName rootUri, String path) {
        this(rootUri.getScheme(), rootUri.getURI(), path, false);
    }

    public BasicFileName(URL rootUrl, String path) {
        this(rootUrl.getProtocol(), rootUrl.toExternalForm(), path, false);
    }

    protected FileName createName(String path) {
        return new BasicFileName(this.getScheme(), this.rootUri, path, true);
    }

    protected void appendRootUri(StringBuffer buffer) {
        buffer.append(this.rootUri);
    }
}

