/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.AbstractVfsContainer;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.FileSystemKey;

public abstract class AbstractFileProvider
extends AbstractVfsContainer
implements FileProvider {
    private final Map fileSystems = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = this.fileSystems;
        synchronized (map) {
            this.fileSystems.clear();
            super.close();
        }
    }

    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions properties) throws FileSystemException {
        throw new FileSystemException("vfs.provider/not-layered-fs.error", scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileSystem(Comparable key, FileSystem fs) throws FileSystemException {
        Map map = this.fileSystems;
        synchronized (map) {
            this.addComponent(fs);
            FileSystemKey treeKey = new FileSystemKey(key, fs.getFileSystemOptions());
            ((AbstractFileSystem)fs).setCacheKey(treeKey);
            this.fileSystems.put(treeKey, fs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem findFileSystem(Comparable key, FileSystemOptions fileSystemProps) {
        Map map = this.fileSystems;
        synchronized (map) {
            FileSystemKey treeKey = new FileSystemKey(key, fileSystemProps);
            return (FileSystem)this.fileSystems.get(treeKey);
        }
    }

    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUnusedResources() {
        Map map = this.fileSystems;
        synchronized (map) {
            Iterator iterFileSystems = this.fileSystems.values().iterator();
            while (iterFileSystems.hasNext()) {
                AbstractFileSystem fs = (AbstractFileSystem)iterFileSystems.next();
                if (!fs.isReleaseable()) continue;
                fs.closeCommunicationLink();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSystem(FileSystem filesystem) {
        Map map = this.fileSystems;
        synchronized (map) {
            AbstractFileSystem fs = (AbstractFileSystem)filesystem;
            this.fileSystems.remove(fs.getCacheKey());
            this.removeComponent(this.fileSystems);
            fs.close();
        }
    }
}

