/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.cache.AbstractFilesCache;
import org.apache.commons.vfs.cache.FileSystemAndNameKey;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.util.Messages;

public class SoftRefFilesCache
extends AbstractFilesCache {
    private Log log = LogFactory.getLog((Class)(class$org$apache$commons$vfs$cache$SoftRefFilesCache == null ? (class$org$apache$commons$vfs$cache$SoftRefFilesCache = SoftRefFilesCache.class$("org.apache.commons.vfs.cache.SoftRefFilesCache")) : class$org$apache$commons$vfs$cache$SoftRefFilesCache));
    private final Map filesystemCache = new HashMap();
    private final Map refReverseMap = new HashMap(100);
    private final ReferenceQueue refqueue = new ReferenceQueue();
    private SoftRefReleaseThread softRefReleaseThread = null;
    static /* synthetic */ Class class$org$apache$commons$vfs$cache$SoftRefFilesCache;
    static /* synthetic */ Class class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread;

    private void startThread() {
        if (this.softRefReleaseThread != null) {
            throw new IllegalStateException(Messages.getString("vfs.impl/SoftRefReleaseThread-already-running.warn"));
        }
        this.softRefReleaseThread = new SoftRefReleaseThread();
        this.softRefReleaseThread.start();
    }

    private void endThread() {
        if (this.softRefReleaseThread != null) {
            this.softRefReleaseThread.requestEnd = true;
            this.softRefReleaseThread.interrupt();
            this.softRefReleaseThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(FileObject file) {
        SoftRefFilesCache softRefFilesCache = this;
        synchronized (softRefFilesCache) {
            Map files = this.getOrCreateFilesystemCache(file.getFileSystem());
            SoftReference<FileObject> ref = new SoftReference<FileObject>(file, this.refqueue);
            FileSystemAndNameKey key = new FileSystemAndNameKey(file.getFileSystem(), file.getName());
            files.put(file.getName(), ref);
            this.refReverseMap.put(ref, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(FileSystem filesystem, FileName name) {
        SoftRefFilesCache softRefFilesCache = this;
        synchronized (softRefFilesCache) {
            Map files = this.getOrCreateFilesystemCache(filesystem);
            SoftReference ref = (SoftReference)files.get(name);
            if (ref == null) {
                return null;
            }
            FileObject fo = (FileObject)ref.get();
            if (fo == null) {
                this.removeFile(filesystem, name);
            }
            return fo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(FileSystem filesystem) {
        SoftRefFilesCache softRefFilesCache = this;
        synchronized (softRefFilesCache) {
            Map files = this.getOrCreateFilesystemCache(filesystem);
            Iterator iterKeys = this.refReverseMap.values().iterator();
            while (iterKeys.hasNext()) {
                FileSystemAndNameKey key = (FileSystemAndNameKey)iterKeys.next();
                if (key.getFileSystem() != filesystem) continue;
                iterKeys.remove();
                files.remove(key.getFileName());
            }
            if (files.size() < 1) {
                this.filesystemClose(filesystem);
            }
        }
    }

    private void filesystemClose(FileSystem filesystem) {
        this.filesystemCache.remove(filesystem);
        if (this.filesystemCache.size() < 1) {
            this.endThread();
        }
        ((DefaultFileSystemManager)this.getContext().getFileSystemManager()).closeFileSystem(filesystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        SoftRefFilesCache softRefFilesCache = this;
        synchronized (softRefFilesCache) {
            this.endThread();
            this.filesystemCache.clear();
            this.refReverseMap.clear();
        }
    }

    public void removeFile(FileSystem filesystem, FileName name) {
        this.removeFile(new FileSystemAndNameKey(filesystem, name));
    }

    public void touchFile(FileObject file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(FileSystemAndNameKey key) {
        SoftRefFilesCache softRefFilesCache = this;
        synchronized (softRefFilesCache) {
            Map files = this.getOrCreateFilesystemCache(key.getFileSystem());
            Object ref = files.remove(key.getFileName());
            if (ref != null) {
                this.refReverseMap.remove(ref);
            }
            if (files.size() < 1) {
                this.filesystemClose(key.getFileSystem());
            }
        }
    }

    protected Map getOrCreateFilesystemCache(FileSystem filesystem) {
        TreeMap files;
        if (this.filesystemCache.size() < 1) {
            this.startThread();
        }
        if ((files = (TreeMap)this.filesystemCache.get(filesystem)) == null) {
            files = new TreeMap();
            this.filesystemCache.put(filesystem, files);
        }
        return files;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SoftRefReleaseThread
    extends Thread {
        private boolean requestEnd = false;

        private SoftRefReleaseThread() {
            this.setName((class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread == null ? (class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread = SoftRefFilesCache.class$("org.apache.commons.vfs.cache.SoftRefFilesCache$SoftRefReleaseThread")) : class$org$apache$commons$vfs$cache$SoftRefFilesCache$SoftRefReleaseThread).getName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.requestEnd && !Thread.currentThread().isInterrupted()) {
                try {
                    Reference ref = SoftRefFilesCache.this.refqueue.remove(1000L);
                    if (ref == null || ref == null) continue;
                    SoftRefFilesCache softRefFilesCache = SoftRefFilesCache.this;
                    synchronized (softRefFilesCache) {
                        FileSystemAndNameKey key = (FileSystemAndNameKey)SoftRefFilesCache.this.refReverseMap.get(ref);
                        if (key != null) {
                            SoftRefFilesCache.this.removeFile(key);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (this.requestEnd) break;
                    VfsLog.warn(SoftRefFilesCache.this.getLogger(), SoftRefFilesCache.this.log, Messages.getString("vfs.impl/SoftRefReleaseThread-interrupt.info"));
                    break;
                }
            }
        }
    }
}

