/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseAdd", inputsClass=Inputs.class)
public final class SparseAdd<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseAdd";
    private Output<TInt64> sumIndices;
    private Output<T> sumValues;
    private Output<TInt64> sumShape;

    public SparseAdd(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sumIndices = operation.output(outputIdx++);
        this.sumValues = operation.output(outputIdx++);
        this.sumShape = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseAdd<T> create(Scope scope, Operand<TInt64> aIndices, Operand<T> aValues, Operand<TInt64> aShape, Operand<TInt64> bIndices, Operand<T> bValues, Operand<TInt64> bShape, Operand<? extends TNumber> thresh) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(aIndices.asOutput());
        opBuilder.addInput(aValues.asOutput());
        opBuilder.addInput(aShape.asOutput());
        opBuilder.addInput(bIndices.asOutput());
        opBuilder.addInput(bValues.asOutput());
        opBuilder.addInput(bShape.asOutput());
        opBuilder.addInput(thresh.asOutput());
        return new SparseAdd<T>(opBuilder.build());
    }

    public Output<TInt64> sumIndices() {
        return this.sumIndices;
    }

    public Output<T> sumValues() {
        return this.sumValues;
    }

    public Output<TInt64> sumShape() {
        return this.sumShape;
    }

    @OpInputsMetadata(outputsClass=SparseAdd.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseAdd<T>> {
        public final Operand<TInt64> aIndices;
        public final Operand<T> aValues;
        public final Operand<TInt64> aShape;
        public final Operand<TInt64> bIndices;
        public final Operand<T> bValues;
        public final Operand<TInt64> bShape;
        public final Operand<? extends TNumber> thresh;
        public final DataType T;
        public final DataType Treal;

        public Inputs(GraphOperation op) {
            super(new SparseAdd(op), op, Arrays.asList("T", "Treal"));
            int inputIndex = 0;
            this.aIndices = op.input(inputIndex++);
            this.aValues = op.input(inputIndex++);
            this.aShape = op.input(inputIndex++);
            this.bIndices = op.input(inputIndex++);
            this.bValues = op.input(inputIndex++);
            this.bShape = op.input(inputIndex++);
            this.thresh = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Treal = op.attributes().getAttrType("Treal");
        }
    }
}

