/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.tensorflow.RawTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.ndarray.buffer.DoubleDataBuffer;
import org.tensorflow.ndarray.impl.dense.DoubleDenseNdArray;
import org.tensorflow.types.TFloat64;

public final class TFloat64Mapper
extends TensorMapper<TFloat64> {
    @Override
    protected TFloat64 mapDense(RawTensor tensor) {
        DoubleDataBuffer buffer = TensorBuffers.toDoubles(TFloat64Mapper.nativeHandle(tensor));
        return new DenseTFloat64(tensor, buffer);
    }

    private static final class DenseTFloat64
    extends DoubleDenseNdArray
    implements TFloat64 {
        final RawTensor rawTensor;

        public Class<TFloat64> type() {
            return TFloat64.class;
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTFloat64(RawTensor rawTensor, DoubleDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

