/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.zoo.cv.objectdetection;

import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.Point;
import ai.djl.modality.cv.output.Rectangle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BoundFinder {
    private final int[] deltaX = new int[]{0, 1, -1, 0};
    private final int[] deltaY = new int[]{1, 0, 0, -1};
    private List<List<Point>> pointsCollection = new ArrayList<List<Point>>();
    private int width;
    private int height;

    public BoundFinder(boolean[][] grid) {
        this.width = grid.length;
        this.height = grid[0].length;
        boolean[][] visited = new boolean[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (!grid[i][j] || visited[i][j]) continue;
                this.pointsCollection.add(this.bfs(grid, i, j, visited));
            }
        }
    }

    public List<List<Point>> getPoints() {
        return this.pointsCollection;
    }

    public List<BoundingBox> getBoxes() {
        return ((Stream)this.pointsCollection.stream().parallel()).map(points -> {
            double[] minMax = new double[]{2.147483647E9, 2.147483647E9, -1.0, -1.0};
            points.forEach(p -> {
                minMax[0] = Math.min(minMax[0], p.getX());
                minMax[1] = Math.min(minMax[1], p.getY());
                minMax[2] = Math.max(minMax[2], p.getX());
                minMax[3] = Math.max(minMax[3], p.getY());
            });
            return new Rectangle(minMax[1], minMax[0], minMax[3] - minMax[1], minMax[2] - minMax[0]);
        }).filter(rect -> rect.getWidth() * (double)this.width > 5.0 && rect.getHeight() * (double)this.height > 5.0).collect(Collectors.toList());
    }

    private List<Point> bfs(boolean[][] grid, int x, int y, boolean[][] visited) {
        ArrayDeque<Point> queue = new ArrayDeque<Point>();
        queue.offer(new Point((double)x, (double)y));
        visited[x][y] = true;
        ArrayList<Point> points = new ArrayList<Point>();
        while (!queue.isEmpty()) {
            Point point = (Point)queue.poll();
            points.add(new Point(point.getX() / (double)this.width, point.getY() / (double)this.height));
            for (int direction = 0; direction < 4; ++direction) {
                int newY;
                int newX = (int)point.getX() + this.deltaX[direction];
                if (!this.isVaild(grid, newX, newY = (int)point.getY() + this.deltaY[direction], visited)) continue;
                queue.offer(new Point((double)newX, (double)newY));
                visited[newX][newY] = true;
            }
        }
        return points;
    }

    private boolean isVaild(boolean[][] grid, int x, int y, boolean[][] visited) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return false;
        }
        if (visited[x][y]) {
            return false;
        }
        return grid[x][y];
    }
}

