/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.zoo;

import ai.djl.Application;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelZoo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class PpModelZoo
implements ModelZoo {
    private static final String DJL_REPO_URL = "https://mlrepo.djl.ai/";
    private static final Repository REPOSITORY = Repository.newInstance((String)"Paddle", (String)"https://mlrepo.djl.ai/");
    private static final PpModelZoo ZOO = new PpModelZoo();
    public static final String GROUP_ID = "ai.djl.paddlepaddle";
    private static final List<ModelLoader> MODEL_LOADERS = new ArrayList<ModelLoader>();

    public List<ModelLoader> getModelLoaders() {
        return MODEL_LOADERS;
    }

    public String getGroupId() {
        return GROUP_ID;
    }

    public Set<String> getSupportedEngines() {
        return Collections.singleton("PaddlePaddle");
    }

    static {
        MRL maskDetection = MRL.model((Application)Application.CV.IMAGE_CLASSIFICATION, (String)GROUP_ID, (String)"mask_classification");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, maskDetection, "0.0.1", (ModelZoo)ZOO));
        MRL wordRotation = MRL.model((Application)Application.CV.IMAGE_CLASSIFICATION, (String)GROUP_ID, (String)"word_rotation");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, wordRotation, "0.0.1", (ModelZoo)ZOO));
        MRL faceDetection = MRL.model((Application)Application.CV.OBJECT_DETECTION, (String)GROUP_ID, (String)"face_detection");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, faceDetection, "0.0.1", (ModelZoo)ZOO));
        MRL wordDetection = MRL.model((Application)Application.CV.OBJECT_DETECTION, (String)GROUP_ID, (String)"word_detection");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, wordDetection, "0.0.1", (ModelZoo)ZOO));
        MRL wordRecognition = MRL.model((Application)Application.CV.WORD_RECOGNITION, (String)GROUP_ID, (String)"word_recognition");
        MODEL_LOADERS.add((ModelLoader)new BaseModelLoader(REPOSITORY, wordRecognition, "0.0.1", (ModelZoo)ZOO));
    }
}

