/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.PostProcessor;
import ai.djl.translate.PreProcessor;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorOptions;
import java.lang.reflect.Array;
import java.util.ArrayList;

public interface Translator<I, O>
extends PreProcessor<I>,
PostProcessor<O> {
    default public Batchifier getBatchifier() {
        return Batchifier.STACK;
    }

    default public void prepare(TranslatorContext ctx) throws Exception {
    }

    default public TranslatorOptions getExpansions() {
        return null;
    }

    default public Translator<I[], O[]> toBatchTranslator() {
        return this.toBatchTranslator(this.getBatchifier());
    }

    default public Translator<I[], O[]> toBatchTranslator(final Batchifier batchifier) {
        if (batchifier == null) {
            return null;
        }
        return new NoBatchifyTranslator<I[], O[]>(){

            @Override
            public void prepare(TranslatorContext ctx) throws Exception {
                Translator.this.prepare(ctx);
            }

            @Override
            public NDList processInput(TranslatorContext ctx, I[] inputs) throws Exception {
                NDList[] preprocessed = new NDList[inputs.length];
                for (int i = 0; i < inputs.length; ++i) {
                    preprocessed[i] = Translator.this.processInput(ctx, inputs[i]);
                }
                return batchifier.batchify(preprocessed);
            }

            @Override
            public O[] processOutput(TranslatorContext ctx, NDList list) throws Exception {
                NDList[] unbatched = batchifier.unbatchify(list);
                ArrayList outputs = new ArrayList(unbatched.length);
                for (NDList output : unbatched) {
                    outputs.add(Translator.this.processOutput(ctx, output));
                }
                Object[] type = (Object[])Array.newInstance(outputs.get(0).getClass(), 0);
                return outputs.toArray(type);
            }
        };
    }
}

