/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.SimpleUrlRepository;
import ai.djl.util.Progress;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarRepository
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(SimpleUrlRepository.class);
    private String artifactId;
    private String modelName;
    private Metadata metadata;
    private boolean resolved;

    JarRepository(String name, URI uri, String fileName) {
        super(name, uri);
        this.modelName = (String)this.arguments.get("model_name");
        this.artifactId = (String)this.arguments.get("artifact_id");
        if (this.artifactId == null) {
            this.artifactId = fileName;
        }
        if (this.modelName == null) {
            this.modelName = this.artifactId;
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public Metadata locate(MRL mrl) {
        return this.getMetadata();
    }

    @Override
    public Artifact resolve(MRL mrl, Map<String, String> filter) {
        List<Artifact> artifacts = this.locate(mrl).getArtifacts();
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }

    @Override
    public List<MRL> getResources() {
        Metadata m = this.getMetadata();
        if (m != null && !m.getArtifacts().isEmpty()) {
            MRL mrl = MRL.undefined(this, m.getGroupId(), m.getArtifactId());
            return Collections.singletonList(mrl);
        }
        return Collections.emptyList();
    }

    @Override
    protected void download(Path tmp, URI baseUri, Artifact.Item item, Progress progress) throws IOException {
        logger.debug("Extracting artifact: {} ...", (Object)this.uri);
        try (BufferedInputStream is = new BufferedInputStream(this.uri.toURL().openStream());){
            this.save(is, tmp, item, progress);
        }
    }

    private synchronized Metadata getMetadata() {
        if (this.resolved) {
            return this.metadata;
        }
        this.resolved = true;
        Artifact artifact = new Artifact();
        artifact.setName(this.modelName);
        artifact.getArguments().putAll(this.arguments);
        ConcurrentHashMap<String, Artifact.Item> files = new ConcurrentHashMap<String, Artifact.Item>();
        Artifact.Item item = new Artifact.Item();
        item.setUri(this.uri.getSchemeSpecificPart());
        item.setName("");
        item.setArtifact(artifact);
        item.setSize(-1L);
        files.put(this.artifactId, item);
        artifact.setFiles(files);
        this.metadata = new Metadata.MatchAllMetadata();
        this.metadata.setArtifactId(this.artifactId);
        this.metadata.setArtifacts(Collections.singletonList(artifact));
        String hash = JarRepository.md5hash(this.uri.toString());
        MRL mrl = this.model(Application.UNDEFINED, "ai.djl.localmodelzoo", hash);
        this.metadata.setRepositoryUri(mrl.toURI());
        return this.metadata;
    }
}

