/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.uow;

import java.util.function.Consumer;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.WorkUnit;

public class ManagedUnitOfWork
implements UnitOfWork {
    private UnitOfWork delegate;
    private Consumer<UnitOfWork> onStart;
    private Consumer<UnitOfWork> onEnd;
    private Consumer<UnitOfWork> onAbort;

    public ManagedUnitOfWork(UnitOfWork delegate, Consumer<UnitOfWork> onStart, Consumer<UnitOfWork> onEnd, Consumer<UnitOfWork> onAbort) {
        this.delegate = delegate;
        this.onStart = onStart;
        this.onEnd = onEnd;
        this.onAbort = onAbort;
    }

    public void start() {
        this.onStart.accept(this.delegate);
        this.delegate.start();
    }

    public void end() {
        this.delegate.end();
        this.onEnd.accept(this.delegate);
    }

    public void abort() {
        this.delegate.abort();
        this.onAbort.accept(this.delegate);
    }

    public void intercept(WorkUnit work) {
        this.delegate.intercept(work);
    }

    public UnitOfWork delegate() {
        return this.delegate;
    }
}

