/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.workflow.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.quarkus.util.deployment.DroolsQuarkusResourceUtils;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.kie.kogito.Model;
import org.kie.kogito.ProcessInput;
import org.kie.kogito.UserTask;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.utils.GeneratedFileValidation;
import org.kie.kogito.codegen.json.JsonSchemaGenerator;
import org.kie.kogito.codegen.process.ProcessContainerGenerator;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.marshaller.MarshallerGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.SimpleCorrelation;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedClassesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoProcessContainerGeneratorBuildItem;
import org.kie.kogito.quarkus.workflow.KogitoBeanProducer;
import org.kie.kogito.quarkus.workflow.deployment.InMemoryClassLoader;
import org.kie.kogito.quarkus.workflow.deployment.JandexMarshallerGenerator;
import org.kie.kogito.quarkus.workflow.deployment.JandexProtoGenerator;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.protobuf.KogitoNodeInstanceContentsProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoProcessInstanceProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoTypesProtobuf;
import org.kie.kogito.serialization.process.protobuf.KogitoWorkItemsProtobuf;

public abstract class WorkflowProcessor {
    private static final String PERSISTENCE_CAPABILITY = "org.kie.kogito.addons.persistence";

    public abstract FeatureBuildItem featureBuildItem();

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void addProtoDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServiceProviderBuildItem> serviceProviderBuildItemBuildProducer, Capabilities capabilities) {
        if (capabilities.isCapabilityWithPrefixPresent(PERSISTENCE_CAPABILITY)) {
            indexDependency.produce((BuildItem)new IndexDependencyBuildItem("com.google.protobuf", "protobuf-java"));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"kogito-types.proto"}));
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"org.kie.kogito.persistence.ProtostreamObjectMarshaller"}));
            resource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{"META-INF/services/" + ObjectMarshallerStrategy.class.getName()}));
            serviceProviderBuildItemBuildProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ObjectMarshallerStrategy.class.getName()));
            this.addInnerClasses(KogitoProcessInstanceProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoTypesProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoNodeInstanceContentsProtobuf.class, reflectiveHierarchyClass);
            this.addInnerClasses(KogitoWorkItemsProtobuf.class, reflectiveHierarchyClass);
        }
    }

    @BuildStep
    public ReflectiveClassBuildItem reflectionProcess(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)"org.kogito.workitem.rest.decorators.RequestDecorator"));
        return new ReflectiveClassBuildItem(true, true, new String[]{"org.kogito.workitem.rest.bodybuilders.ParamsRestWorkItemHandlerBodyBuilder", "org.kogito.workitem.rest.decorators.CollectionParamsDecorator", "org.kogito.workitem.rest.auth.ClientOAuth2AuthDecorator", "org.kogito.workitem.rest.auth.PasswordOAuth2AuthDecorator", "io.vertx.core.http.HttpMethod", "org.kie.kogito.process.impl.BaseWorkItem", "org.kie.kogito.event.Topic", "org.kie.kogito.event.cloudevents.CloudEventMeta", "org.kie.kogito.event.cloudevents.SpecVersionDeserializer", "org.kie.kogito.event.cloudevents.SpecVersionSerializer", "org.kie.kogito.jobs.api.Job", CompositeCorrelation.class.getCanonicalName(), SimpleCorrelation.class.getCanonicalName(), Correlation.class.getCanonicalName(), CorrelationInstance.class.getCanonicalName(), ExceptionScope.class.getCanonicalName()});
    }

    @BuildStep
    public AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().addBeanClasses(new Class[]{KogitoBeanProducer.class}).build();
    }

    @BuildStep
    public void processApplicationSection(KogitoBuildContextBuildItem kogitoBuildContextBuildItem, BuildProducer<KogitoProcessContainerGeneratorBuildItem> processContainerProducer, KogitoGeneratedSourcesBuildItem generatedKogitoClasses) {
        KogitoProcessContainerGeneratorBuildItem buildItem = new KogitoProcessContainerGeneratorBuildItem(kogitoBuildContextBuildItem.getKogitoBuildContext().getApplicationSections().stream().filter(ProcessContainerGenerator.class::isInstance).map(ProcessContainerGenerator.class::cast).collect(Collectors.toSet()));
        if (!buildItem.getProcessContainerGenerators().isEmpty()) {
            processContainerProducer.produce((BuildItem)buildItem);
        }
    }

    @BuildStep
    public void postGenerationProcessing(List<KogitoGeneratedClassesBuildItem> generatedKogitoClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalStaticResourceBuildItem> staticResProducer, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<GeneratedResourceBuildItem> genResBI, CombinedIndexBuildItem combinedIndexBuildItem, KogitoBuildContextBuildItem kogitoBuildContextBuildItem, Capabilities capabilities, LiveReloadBuildItem liveReload, CurateOutcomeBuildItem curateOutcomeBuildItem) throws IOException {
        IndexView aggregatedIndex = KogitoQuarkusResourceUtils.generateAggregatedIndex((IndexView)combinedIndexBuildItem.getComputingIndex(), generatedKogitoClasses);
        KogitoBuildContext context = kogitoBuildContextBuildItem.getKogitoBuildContext();
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        if (capabilities.isCapabilityWithPrefixPresent(PERSISTENCE_CAPABILITY)) {
            generatedFiles.addAll(this.generatePersistenceInfo(context, aggregatedIndex, generatedBeans, curateOutcomeBuildItem, liveReload.isLiveReload()));
        }
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (KogitoGeneratedClassesBuildItem generatedKogitoClass : generatedKogitoClasses) {
            classes.putAll(generatedKogitoClass.getGeneratedClasses());
        }
        generatedFiles.addAll(this.generateJsonSchema(context, aggregatedIndex, classes));
        KogitoQuarkusResourceUtils.dumpFilesToDisk((AppPaths)context.getAppPaths(), generatedFiles);
        KogitoQuarkusResourceUtils.registerResources(generatedFiles, staticResProducer, resource, genResBI);
    }

    private Collection<GeneratedFile> generatePersistenceInfo(KogitoBuildContext context, IndexView index, BuildProducer<GeneratedBeanBuildItem> generatedBeans, CurateOutcomeBuildItem curateOutcomeBuildItem, boolean useDebugSymbols) {
        Collection<GeneratedFile> persistenceGeneratedFiles = this.getGeneratedPersistenceFiles(index, context);
        GeneratedFileValidation.validateGeneratedFileTypes(persistenceGeneratedFiles, Arrays.asList(GeneratedFileType.Category.SOURCE, GeneratedFileType.Category.INTERNAL_RESOURCE, GeneratedFileType.Category.STATIC_HTTP_RESOURCE));
        Collection dependencies = curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        DroolsQuarkusResourceUtils.compileGeneratedSources((DroolsModelBuildContext)context, (Collection)dependencies, persistenceGeneratedFiles, (boolean)useDebugSymbols).forEach(arg_0 -> generatedBeans.produce(arg_0));
        return persistenceGeneratedFiles;
    }

    private Collection<GeneratedFile> getGeneratedPersistenceFiles(IndexView index, KogitoBuildContext context) {
        Collection modelClasses = index.getAllKnownImplementors(DotName.createSimple((String)Model.class.getCanonicalName()));
        JandexProtoGenerator protoGenerator = (JandexProtoGenerator)JandexProtoGenerator.builder(index).build(modelClasses);
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator, (MarshallerGenerator)new JandexMarshallerGenerator(context, modelClasses));
        return persistenceGenerator.generate();
    }

    private void addInnerClasses(Class<?> superClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass) {
        DotName dotName = DotName.createSimple((String)superClass.getName());
        Type type = Type.create((DotName)dotName, (Type.Kind)Type.Kind.CLASS);
        reflectiveHierarchyClass.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(type).build());
        Arrays.asList(superClass.getDeclaredClasses()).forEach(c -> this.addInnerClasses((Class<?>)c, reflectiveHierarchyClass));
    }

    private Collection<GeneratedFile> generateJsonSchema(KogitoBuildContext context, IndexView index, Map<String, byte[]> generatedClasses) throws IOException {
        InMemoryClassLoader cl = new InMemoryClassLoader(context.getClassLoader(), generatedClasses);
        ArrayList annotations = new ArrayList();
        annotations.addAll(index.getAnnotations(DotName.createSimple((String)ProcessInput.class.getCanonicalName())));
        annotations.addAll(index.getAnnotations(DotName.createSimple((String)UserTask.class.getCanonicalName())));
        List annotatedClasses = annotations.stream().map(ann -> this.loadClassFromAnnotation((AnnotationInstance)ann, cl)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator.ClassBuilder(annotatedClasses.stream()).withSchemaVersion(System.getProperty("kogito.jsonSchema.version")).build();
        return jsonSchemaGenerator.generate();
    }

    private Optional<Class<?>> loadClassFromAnnotation(AnnotationInstance annotationInstance, ClassLoader classLoader) {
        try {
            return Optional.of(classLoader.loadClass(annotationInstance.target().asClass().name().toString()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

