/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml;

import java.util.Map;
import org.kie.api.pmml.PMML4Result;
import org.kie.api.pmml.PMMLRequestData;
import org.kie.kogito.pmml.PMMLKogito;
import org.kie.kogito.pmml.utils.PMMLUtils;
import org.kie.kogito.prediction.PredictionModel;
import org.kie.memorycompiler.KieMemoryCompiler;
import org.kie.pmml.api.models.PMMLModel;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.api.runtime.PMMLRuntimeContext;
import org.kie.pmml.evaluator.core.PMMLRuntimeContextImpl;

public class PmmlPredictionModel
implements PredictionModel {
    private final PMMLRuntime pmmlRuntime;
    private final PMMLModel pmmlModel;

    public PmmlPredictionModel(PMMLRuntime pmmlRuntime, String fileName, String modelName) {
        this.pmmlRuntime = pmmlRuntime;
        this.pmmlModel = PMMLKogito.modelByName(pmmlRuntime, fileName, modelName);
        if (this.pmmlModel == null) {
            String exceptionString = String.format("PMML model %s@%s not found in the inherent PMMLRuntime.", modelName, fileName);
            throw new IllegalStateException(exceptionString);
        }
    }

    @Override
    public PMMLRuntimeContext newContext(Map<String, Object> variables) {
        PMMLRequestData pmmlRequestData = PMMLUtils.getPMMLRequestData(this.pmmlModel.getName(), variables);
        KieMemoryCompiler.MemoryCompilerClassLoader memoryCompilerClassLoader = new KieMemoryCompiler.MemoryCompilerClassLoader(Thread.currentThread().getContextClassLoader());
        return new PMMLRuntimeContextImpl(pmmlRequestData, this.pmmlModel.getFileName(), memoryCompilerClassLoader);
    }

    @Override
    public PMML4Result evaluateAll(PMMLRuntimeContext context) {
        return this.pmmlRuntime.evaluate(this.pmmlModel.getName(), context);
    }

    @Override
    public PMMLModel getPMMLModel() {
        return this.pmmlModel;
    }
}

