/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.maven.plugin.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.CumulativeScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.kogito.codegen.manager.util.CodeGenManagerUtil;
import org.kie.util.maven.support.ReleaseIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MojoUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MojoUtil.class);

    public static Set<URI> getProjectFiles(MavenProject mavenProject, List<InternalKieModule> kmoduleDeps) throws DependencyResolutionRequiredException, IOException {
        Set<URI> toReturn = MojoUtil.getScaffoldFiles(mavenProject, kmoduleDeps);
        for (String element : mavenProject.getCompileClasspathElements()) {
            toReturn.add(new File(element).toURI());
        }
        return toReturn;
    }

    public static Set<URI> getScaffoldFiles(MavenProject mavenProject, List<InternalKieModule> kmoduleDeps) throws IOException {
        HashSet<URI> toReturn = new HashSet<URI>();
        mavenProject.setArtifactFilter((ArtifactFilter)new CumulativeScopeArtifactFilter(Arrays.asList("compile", "runtime")));
        for (Artifact artifact : mavenProject.getArtifacts()) {
            if (!artifact.getType().equals("jar")) continue;
            MojoUtil.populateURLsFromJarArtifact(toReturn, artifact, kmoduleDeps);
        }
        return toReturn;
    }

    public static ClassLoader createProjectClassLoader(ClassLoader parentClassLoader, MavenProject mavenProject, File outputDirectory, List<InternalKieModule> kmoduleDeps) throws MojoExecutionException {
        try {
            Set<URI> uris = MojoUtil.getProjectFiles(mavenProject, kmoduleDeps);
            uris.add(outputDirectory.toURI());
            URL[] urlArray = CodeGenManagerUtil.convertURIsToURLs(uris);
            LOGGER.debug("Creating maven project class loading with: {}", Arrays.asList(urlArray));
            return URLClassLoader.newInstance(urlArray, parentClassLoader);
        }
        catch (IOException | DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error setting up Kie ClassLoader", (Exception)e);
        }
    }

    private static void populateURLsFromJarArtifact(Set<URI> toPopulate, Artifact artifact, List<InternalKieModule> kmoduleDeps) throws IOException {
        File file = artifact.getFile();
        if (file != null && file.isFile()) {
            toPopulate.add(file.toURI());
            KieModuleModel depModel = MojoUtil.getDependencyKieModel(file);
            if (kmoduleDeps != null && depModel != null) {
                ReleaseIdImpl releaseId = new ReleaseIdImpl(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
                kmoduleDeps.add((InternalKieModule)new ZipKieModule((ReleaseId)releaseId, depModel, file));
            }
        }
    }

    private static KieModuleModel getDependencyKieModel(File jar) throws IOException {
        try (ZipFile zipFile = new ZipFile(jar);){
            ZipEntry zipEntry = zipFile.getEntry(KieModuleModelImpl.KMODULE_JAR_PATH.asString());
            if (zipEntry != null) {
                KieModuleModel kieModuleModel = KieModuleModelImpl.fromXML((InputStream)zipFile.getInputStream(zipEntry));
                KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieModuleModel);
                KieModuleModel kieModuleModel2 = kieModuleModel;
                return kieModuleModel2;
            }
        }
        return null;
    }

    public static boolean hasDependency(MavenProject mavenProject, CodeGenManagerUtil.Framework framework) {
        return mavenProject.getDependencies().stream().anyMatch(d -> d.getArtifactId().contains(framework.toName()));
    }

    public static boolean hasClassOnClasspath(MavenProject project, String className) {
        try {
            Set elements = project.getArtifacts();
            HashSet<URI> uris = new HashSet<URI>();
            for (Artifact artifact : elements) {
                uris.add(artifact.getFile().toURI());
            }
            return CodeGenManagerUtil.isClassNameInUrlClassLoader(uris, (String)className);
        }
        catch (Exception e) {
            return false;
        }
    }

    private MojoUtil() {
    }
}

