/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jackson.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.cloudevents.jackson.JsonFormat;
import org.kie.kogito.jackson.utils.JsonNodeFactoryListener;

public class ObjectMapperFactory {
    private ObjectMapperFactory() {
    }

    public static ObjectMapper get() {
        return DefaultObjectMapper.instance;
    }

    public static ObjectMapper listenerAware() {
        return ListenerAwareMapper.instance;
    }

    private static class DefaultObjectMapper {
        private static ObjectMapper instance = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build()).setSerializationInclusion(JsonInclude.Include.NON_NULL).setTypeFactory(TypeFactory.defaultInstance().withClassLoader(Thread.currentThread().getContextClassLoader())).registerModule((Module)JsonFormat.getCloudEventJacksonModule()).findAndRegisterModules();

        private DefaultObjectMapper() {
        }
    }

    private static class ListenerAwareMapper {
        private static ObjectMapper instance = DefaultObjectMapper.instance.copy().setNodeFactory((JsonNodeFactory)new JsonNodeFactoryListener());

        private ListenerAwareMapper() {
        }
    }
}

