/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.rule;

import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.rule.DecisionRuleType;
import org.jbpm.workflow.instance.rule.RuleFlowGroupRuleType;
import org.jbpm.workflow.instance.rule.RuleUnitRuleType;

public interface RuleType {
    public static final String UNIT_RULEFLOW_PREFIX = "unit:";
    public static final String DRL_LANG = "http://www.jboss.org/drools/rule";
    public static final String RULE_UNIT_LANG = "http://www.jboss.org/drools/rule-unit";
    public static final String DMN_LANG = "http://www.jboss.org/drools/dmn";

    public String getName();

    public void evaluate(RuleSetNodeInstance var1);

    public boolean isRuleFlowGroup();

    public boolean isRuleUnit();

    public boolean isDecision();

    public static RuleType of(String name, String language) {
        if (DRL_LANG.equals(language)) {
            return RuleType.parseRuleFlowGroup(name);
        }
        if (RULE_UNIT_LANG.equals(language)) {
            return RuleType.ruleUnit(name);
        }
        throw new IllegalArgumentException("Unsupported language " + language);
    }

    private static RuleType parseRuleFlowGroup(String name) {
        if (name.startsWith(UNIT_RULEFLOW_PREFIX)) {
            String unitId = name.substring(UNIT_RULEFLOW_PREFIX.length());
            return RuleType.ruleUnit(unitId);
        }
        return RuleType.ruleFlowGroup(name);
    }

    public static RuleFlowGroupRuleType ruleFlowGroup(String name) {
        return new RuleFlowGroupRuleType(name);
    }

    public static RuleUnitRuleType ruleUnit(String name) {
        return new RuleUnitRuleType(name);
    }

    public static DecisionRuleType decision(String namespace, String model, String decision) {
        return new DecisionRuleType(namespace, model, decision);
    }
}

