/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.impl.XmlProcessDumper;
import org.jbpm.process.core.impl.XmlProcessDumperFactory;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.workflow.core.WorkflowProcess;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.rule.Agenda;

public abstract class ProcessInstanceImpl
implements ProcessInstance,
Serializable {
    private static final long serialVersionUID = 510L;
    private String id;
    private String processId;
    private transient Process process;
    private String processXml;
    private int state = 0;
    private Map<String, ContextInstance> contextInstances = new HashMap<String, ContextInstance>();
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private transient InternalKnowledgeRuntime kruntime;
    private Map<String, Object> metaData = new HashMap<String, Object>();
    private String outcome;
    private String parentProcessInstanceId;
    private String rootProcessInstanceId;
    private String description;
    private String rootProcessId;
    private Map<String, List<String>> headers;
    private String processVersion;

    public String getId() {
        return this.id;
    }

    public String getStringId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void updateProcess(Process process) {
        this.setProcess(process);
        XmlProcessDumper dumper = XmlProcessDumperFactory.newXmlProcessDumperFactory();
        this.processXml = dumper.dumpProcess(process);
    }

    public String getProcessXml() {
        return this.processXml;
    }

    public void setProcessXml(String processXml) {
        if (processXml != null && processXml.trim().length() > 0) {
            this.processXml = processXml;
        }
    }

    @Override
    public Process getProcess() {
        if (this.process == null) {
            if (this.processXml == null) {
                if (this.kruntime == null) {
                    throw new IllegalStateException("Process instance " + this.id + "[" + this.processId + "] is disconnected.");
                }
                this.process = this.kruntime.getKieBase().getProcess(this.processId);
            } else {
                XmlProcessDumper dumper = XmlProcessDumperFactory.newXmlProcessDumperFactory();
                this.process = dumper.readProcess(this.processXml);
            }
        }
        return this.process;
    }

    @Override
    public void setProcess(Process process) {
        this.processId = process.getId();
        this.processVersion = process.getVersion();
        this.process = process;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.getProcess().getName();
    }

    @Override
    public void setState(int state, String outcome) {
        this.outcome = outcome;
        this.internalSetState(state);
    }

    public void internalSetState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.internalSetState(state);
    }

    @Override
    public InternalKnowledgeRuntime getKnowledgeRuntime() {
        return this.kruntime;
    }

    @Override
    public void setKnowledgeRuntime(InternalKnowledgeRuntime kruntime) {
        if (this.kruntime != null) {
            throw new IllegalArgumentException("Runtime can only be set once.");
        }
        this.kruntime = kruntime;
    }

    public Agenda getAgenda() {
        if (this.getKnowledgeRuntime() == null) {
            return null;
        }
        return this.getKnowledgeRuntime().getAgenda();
    }

    @Override
    public ContextContainer getContextContainer() {
        return (ContextContainer)this.getProcess();
    }

    public void setContextInstance(String contextId, ContextInstance contextInstance) {
        this.contextInstances.put(contextId, contextInstance);
    }

    @Override
    public ContextInstance getContextInstance(String contextId) {
        ContextInstance contextInstance = this.contextInstances.get(contextId);
        if (contextInstance != null) {
            return contextInstance;
        }
        Context context = ((ContextContainer)this.getProcess()).getDefaultContext(contextId);
        if (context != null) {
            contextInstance = this.getContextInstance(context);
            return contextInstance;
        }
        return null;
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this);
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    public void signalEvent(String type, Object event) {
    }

    @Override
    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(String trigger) {
        ProcessInstanceImpl processInstanceImpl = this;
        synchronized (processInstanceImpl) {
            if (this.getState() != 0) {
                throw new IllegalArgumentException("A process instance can only be started once");
            }
            this.setState(1);
            this.internalStart(trigger);
        }
    }

    protected abstract void internalStart(String var1);

    @Override
    public void disconnect() {
        ((InternalProcessRuntime)this.kruntime.getProcessRuntime()).getProcessInstanceManager().internalRemoveProcessInstance(this);
        this.kruntime = null;
    }

    @Override
    public void reconnect() {
        ((InternalProcessRuntime)this.kruntime.getProcessRuntime()).getProcessInstanceManager().internalAddProcessInstance(this);
    }

    public String[] getEventTypes() {
        return new String[0];
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ProcessInstance ");
        b.append(this.getStringId());
        b.append(" [processId=");
        b.append(this.process.getId());
        b.append(",state=");
        b.append(this.state);
        b.append("]");
        return b.toString();
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    @Override
    public void setMetaData(String name, Object data) {
        this.metaData.put(name, data);
    }

    @Override
    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    @Override
    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    @Override
    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public String getRootProcessId() {
        return this.rootProcessId;
    }

    @Override
    public void setRootProcessId(String rootProcessId) {
        this.rootProcessId = rootProcessId;
    }

    public String getDescription() {
        if (this.description == null) {
            Object metaData;
            this.description = this.process.getName();
            if (this.process != null && (metaData = this.process.getMetaData().get("customDescription")) instanceof String) {
                this.description = ((WorkflowProcess)this.process).evaluateExpression((String)metaData, this);
            }
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }
}

