/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.command;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.command.KogitoProcessInstanceIdCommand;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.internal.command.RegistryContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

@XmlRootElement(name="suspend-process-instance-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class SuspendProcessInstanceCommand
implements ExecutableCommand<Object>,
KogitoProcessInstanceIdCommand {
    private static final long serialVersionUID = 5824052805419980114L;
    @XmlAttribute
    @XmlSchemaType(name="string")
    private String processInstanceId;

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Object execute(Context context) {
        KogitoProcessRuntime runtime = (KogitoProcessRuntime)((RegistryContext)context).lookup(KieSession.class);
        if (this.processInstanceId == null) {
            return null;
        }
        KogitoProcessInstance processInstance = runtime.getProcessInstance(this.processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + this.processInstanceId);
        }
        if (processInstance.getState() != 1) {
            throw new IllegalArgumentException("Process instance with id " + this.processInstanceId + " in state " + processInstance.getState());
        }
        ((ProcessInstance)processInstance).setState(4);
        return null;
    }

    public String toString() {
        return "session.abortProcessInstance(" + this.processInstanceId + ");";
    }
}

