/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import org.apache.commons.text.StringEscapeUtils;
import org.dmg.pmml.TextIndex;
import org.kie.pmml.api.enums.COUNT_HITS;
import org.kie.pmml.api.enums.LOCAL_TERM_WEIGHTS;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;
import org.kie.pmml.commons.model.expressions.KiePMMLTextIndex;
import org.kie.pmml.compiler.commons.factories.KiePMMLExpressionInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLExtensionInstanceFactory;
import org.kie.pmml.compiler.commons.factories.KiePMMLTextIndexNormalizationInstanceFactory;

public class KiePMMLTextIndexInstanceFactory {
    private KiePMMLTextIndexInstanceFactory() {
    }

    static KiePMMLTextIndex getKiePMMLTextIndex(TextIndex textIndex) {
        LOCAL_TERM_WEIGHTS localTermWeights = textIndex.getLocalTermWeights() != null ? LOCAL_TERM_WEIGHTS.byName((String)textIndex.getLocalTermWeights().value()) : null;
        COUNT_HITS countHits = textIndex.getCountHits() != null ? COUNT_HITS.byName((String)textIndex.getCountHits().value()) : null;
        String wordSeparatorCharacterRE = textIndex.getWordSeparatorCharacterRE() != null ? StringEscapeUtils.escapeJava((String)textIndex.getWordSeparatorCharacterRE()) : null;
        return (KiePMMLTextIndex)KiePMMLTextIndex.builder((String)textIndex.getTextField(), KiePMMLExtensionInstanceFactory.getKiePMMLExtensions(textIndex.getExtensions()), (KiePMMLExpression)KiePMMLExpressionInstanceFactory.getKiePMMLExpression(textIndex.getExpression())).withTextIndexNormalizations(KiePMMLTextIndexNormalizationInstanceFactory.getKiePMMLTextIndexNormalizations(textIndex.getTextIndexNormalizations())).withLocalTermWeights(localTermWeights).withIsCaseSensitive(textIndex.isCaseSensitive()).withMaxLevenshteinDistance(textIndex.getMaxLevenshteinDistance().intValue()).withCountHits(countHits).withWordSeparatorCharacterRE(wordSeparatorCharacterRE).withTokenize(textIndex.isTokenize()).build();
    }
}

