/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.DMNUnaryTest;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.openapi.NamingPolicy;
import org.kie.dmn.openapi.impl.DMNUnaryTestsMapper;
import org.kie.dmn.openapi.impl.FEELBuiltinTypeSchemaMapper;
import org.kie.dmn.openapi.model.DMNModelIOSets;
import org.kie.dmn.typesafe.DMNTypeUtils;

public class DMNTypeSchemas {
    private final List<DMNModelIOSets> ioSets;
    private final Set<DMNType> typesIndex;
    private final NamingPolicy namingPolicy;

    public DMNTypeSchemas(List<DMNModelIOSets> ioSets, Set<DMNType> typesIndex, NamingPolicy namingPolicy) {
        this.ioSets = Collections.unmodifiableList(ioSets);
        this.typesIndex = Collections.unmodifiableSet(typesIndex);
        this.namingPolicy = namingPolicy;
    }

    public Map<DMNType, Schema> generateSchemas() {
        HashMap<DMNType, Schema> schemas = new HashMap<DMNType, Schema>();
        for (DMNType t : this.typesIndex) {
            Schema schema = this.schemaFromType(t);
            schemas.put(t, schema);
        }
        return schemas;
    }

    static void populateSchemaWithConstraints(Schema toPopulate, SimpleTypeImpl t) {
        if (t.getAllowedValues() != null && !t.getAllowedValues().isEmpty()) {
            DMNTypeSchemas.parseSimpleType("x-dmn-allowed-values", toPopulate, t.getAllowedValuesFEEL(), t.getAllowedValues());
        }
        if (t.getTypeConstraint() != null && !t.getTypeConstraint().isEmpty()) {
            DMNTypeSchemas.parseSimpleType("x-dmn-type-constraints", toPopulate, t.getTypeConstraintFEEL(), t.getTypeConstraint());
        }
    }

    static void parseSimpleType(String schemaString, Schema schema, List<UnaryTest> feelUnaryTests, List<DMNUnaryTest> dmnUnaryTests) {
        schema.addExtension(schemaString, (Object)feelUnaryTests.stream().map(Object::toString).collect(Collectors.joining(", ")));
        DMNUnaryTestsMapper.populateSchemaFromUnaryTests(schema, dmnUnaryTests);
    }

    private Schema schemaFromType(DMNType t) {
        if (t instanceof CompositeTypeImpl) {
            CompositeTypeImpl compositeType = (CompositeTypeImpl)t;
            return this.schemaFromCompositeType(compositeType);
        }
        if (t instanceof SimpleTypeImpl) {
            SimpleTypeImpl simpleType = (SimpleTypeImpl)t;
            return this.schemaFromSimpleType(simpleType);
        }
        throw new UnsupportedOperationException();
    }

    private Schema schemaFromSimpleType(SimpleTypeImpl t) {
        DMNType baseType = t.getBaseType();
        if (baseType == null) {
            throw new IllegalStateException();
        }
        Schema schema = this.refOrBuiltinSchema(baseType);
        DMNTypeSchemas.populateSchemaWithConstraints(schema, t);
        schema = this.nestAsItemIfCollection(schema, (DMNType)t);
        schema.addExtension("x-dmn-type", (Object)this.getDMNTypeSchemaXDMNTYPEdescr((DMNType)t));
        this.processIoSetDoc(schema, (DMNType)t);
        return schema;
    }

    private Schema refOrBuiltinSchema(DMNType t) {
        if (DMNTypeUtils.isFEELBuiltInType((DMNType)t)) {
            return FEELBuiltinTypeSchemaMapper.from(t);
        }
        if (this.typesIndex.contains(t)) {
            return (Schema)((Schema)OASFactory.createObject(Schema.class)).ref(this.namingPolicy.getRef(t));
        }
        throw new UnsupportedOperationException();
    }

    private boolean isIOSetForInputScope(DMNType t) {
        for (DMNModelIOSets ios : this.ioSets) {
            if (ios.getInputSet().equals(t)) {
                return true;
            }
            for (DMNModelIOSets.DSIOSets ds : ios.getDSIOSets()) {
                if (!ds.getDSInputSet().equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    private Optional<Map<String, String>> ioSetDoc(DMNType t) {
        Map<String, String> res = null;
        for (DMNModelIOSets ios : this.ioSets) {
            if (ios.getInputSet().equals(t)) {
                res = ios.getInputDoc();
            } else if (ios.getOutputSet().equals(t)) {
                res = ios.getOutputDoc();
            }
            for (DMNModelIOSets.DSIOSets ds : ios.getDSIOSets()) {
                if (ds.getDSInputSet().equals(t)) {
                    res = ds.getInputDoc();
                    continue;
                }
                if (!ds.getDSOutputSet().equals(t)) continue;
                res = ds.getOutputDoc();
            }
        }
        return Optional.ofNullable(res);
    }

    private Schema schemaFromCompositeType(CompositeTypeImpl ct) {
        Schema schema = ((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.OBJECT);
        if (ct.getBaseType() == null) {
            for (Map.Entry fkv : ct.getFields().entrySet()) {
                schema.addProperty((String)fkv.getKey(), this.refOrBuiltinSchema((DMNType)fkv.getValue()));
            }
            if (this.isIOSetForInputScope((DMNType)ct) && !ct.getFields().isEmpty()) {
                schema.required(new ArrayList(ct.getFields().keySet()));
            }
        } else {
            schema = this.refOrBuiltinSchema(ct.getBaseType());
        }
        schema = this.nestAsItemIfCollection(schema, (DMNType)ct);
        schema.addExtension("x-dmn-type", (Object)this.getDMNTypeSchemaXDMNTYPEdescr((DMNType)ct));
        this.processIoSetDoc(schema, (DMNType)ct);
        return schema;
    }

    private void processIoSetDoc(Schema schema, DMNType type) {
        this.ioSetDoc(type).ifPresent(x -> schema.addExtension("x-dmn-descriptions", x));
    }

    private Schema nestAsItemIfCollection(Schema original, DMNType t) {
        if (t.isCollection()) {
            return ((Schema)OASFactory.createObject(Schema.class)).addType(Schema.SchemaType.ARRAY).items(original);
        }
        return original;
    }

    private String getDMNTypeSchemaXDMNTYPEdescr(DMNType t) {
        if (((BaseDMNTypeImpl)t).getBelongingType() == null) {
            return t.toString();
        }
        return null;
    }
}

