/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNVersion;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.FEELDialect;
import org.kie.dmn.feel.lang.ast.AtLiteralNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.NullNode;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.lang.ast.StringNode;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseNodeSchemaMapper {
    private static final Logger LOG = LoggerFactory.getLogger(BaseNodeSchemaMapper.class);
    private static final Map<Class<? extends BaseNode>, BiConsumer<BaseNode, Schema>> SCHEMA_MODIFIERS;
    private static BiConsumer<BaseNode, Schema> STRINGNODE_CONSUMER;
    private static BiConsumer<BaseNode, Schema> NUMBERNODE_CONSUMER;
    private static BiConsumer<BaseNode, Schema> ATLITERALNODE_CONSUMER;
    private static BiConsumer<BaseNode, Schema> NULLNODE_CONSUMER;

    static void populateSchemaFromBaseNode(Schema toPopulate, BaseNode baseNode) {
        LOG.debug("populateSchemaFromUnaryTests {} {}", (Object)toPopulate, (Object)baseNode);
        if (SCHEMA_MODIFIERS.containsKey(baseNode.getClass())) {
            SCHEMA_MODIFIERS.get(baseNode.getClass()).accept(baseNode, toPopulate);
        }
    }

    private static void populateEnumSchema(Schema toPopulate, Object toAdd) {
        LOG.debug("populateSchemaFromUnaryTests {} {}", (Object)toPopulate, toAdd);
        HashSet<Object> enums = new HashSet<Object>();
        enums.add(toAdd);
        if (toPopulate.getEnumeration() != null) {
            enums.addAll(toPopulate.getEnumeration());
        }
        toPopulate.enumeration(new ArrayList(enums));
    }

    private BaseNodeSchemaMapper() {
    }

    static {
        STRINGNODE_CONSUMER = (node, schema) -> BaseNodeSchemaMapper.populateEnumSchema(schema, ((StringNode)node).getValue());
        NUMBERNODE_CONSUMER = (node, schema) -> BaseNodeSchemaMapper.populateEnumSchema(schema, ((NumberNode)node).getValue());
        ATLITERALNODE_CONSUMER = (node, schema) -> {
            EvaluationContextImpl emptyEvalCtx = new EvaluationContextImpl(BaseNodeSchemaMapper.class.getClassLoader(), new FEELEventListenersManager(), FEELDialect.FEEL, DMNVersion.getLatest());
            Object evaluated = node.evaluate((EvaluationContext)emptyEvalCtx);
            Object toStore = evaluated != null ? evaluated : ((AtLiteralNode)node).getStringLiteral().toString();
            BaseNodeSchemaMapper.populateEnumSchema(schema, toStore);
        };
        NULLNODE_CONSUMER = (node, schema) -> BaseNodeSchemaMapper.populateEnumSchema(schema, null);
        SCHEMA_MODIFIERS = new HashMap<Class<? extends BaseNode>, BiConsumer<BaseNode, Schema>>();
        SCHEMA_MODIFIERS.put(StringNode.class, STRINGNODE_CONSUMER);
        SCHEMA_MODIFIERS.put(NumberNode.class, NUMBERNODE_CONSUMER);
        SCHEMA_MODIFIERS.put(AtLiteralNode.class, ATLITERALNODE_CONSUMER);
        SCHEMA_MODIFIERS.put(NullNode.class, NULLNODE_CONSUMER);
    }
}

