/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.RowLocation;
import org.kie.dmn.model.impl.AbstractTArtifact;
import org.kie.dmn.model.impl.AbstractTDMNElement;
import org.kie.dmn.model.impl.AbstractTDRGElement;
import org.kie.dmn.model.impl.AbstractTDefinitions;
import org.kie.dmn.model.impl.AbstractTItemDefinition;
import org.kie.dmn.model.impl.AbstractTNamedElement;

public abstract class AbstractKieDMNModelInstrumentedBase
implements DMNModelInstrumentedBase {
    private Map<String, String> nsContext;
    private DMNModelInstrumentedBase parent;
    private final List<DMNModelInstrumentedBase> children = new ArrayList<DMNModelInstrumentedBase>();
    private Location location;
    private Map<QName, String> additionalAttributes = new HashMap<QName, String>();

    @Override
    public String getIdentifierString() {
        if (this instanceof AbstractTNamedElement && ((AbstractTNamedElement)this).getName() != null) {
            return ((AbstractTNamedElement)this).getName();
        }
        if (this instanceof AbstractTDMNElement && ((AbstractTDMNElement)this).getId() != null) {
            return ((AbstractTDMNElement)this).getId();
        }
        return "[unnamed " + this.getClass().getSimpleName() + "]";
    }

    @Override
    public DMNModelInstrumentedBase getParentDRDElement() {
        if (this instanceof AbstractTDRGElement || this instanceof AbstractTArtifact || this instanceof AbstractTItemDefinition && this.parent != null && this.parent instanceof AbstractTDefinitions) {
            return this;
        }
        if (this.parent != null) {
            return this.parent.getParentDRDElement();
        }
        return null;
    }

    @Override
    public Map<String, String> getNsContext() {
        if (this.nsContext == null) {
            this.nsContext = new HashMap<String, String>();
        }
        return this.nsContext;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (this.nsContext != null && this.nsContext.containsKey(prefix)) {
            return this.nsContext.get(prefix);
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return null;
    }

    @Override
    public Optional<String> getPrefixForNamespaceURI(String namespaceURI) {
        if (this.nsContext != null && this.nsContext.containsValue(namespaceURI)) {
            return this.nsContext.entrySet().stream().filter(kv -> ((String)kv.getValue()).equals(namespaceURI)).findFirst().map(Map.Entry::getKey);
        }
        if (this.parent != null) {
            return this.parent.getPrefixForNamespaceURI(namespaceURI);
        }
        return Optional.empty();
    }

    @Override
    public void setAdditionalAttributes(Map<QName, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Override
    public Map<QName, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public DMNModelInstrumentedBase getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DMNModelInstrumentedBase parent) {
        this.parent = parent;
    }

    @Override
    public List<DMNModelInstrumentedBase> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public void addChildren(DMNModelInstrumentedBase child) {
        this.children.add(child);
    }

    @Override
    public void setLocation(Location location) {
        this.location = new RowLocation(location);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public <T extends DMNModelInstrumentedBase> List<? extends T> findAllChildren(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            AbstractKieDMNModelInstrumentedBase obj = this;
            return Collections.singletonList(obj);
        }
        ArrayList<T> results = new ArrayList<T>();
        for (DMNModelInstrumentedBase c : this.getChildren()) {
            results.addAll(c.findAllChildren(clazz));
        }
        return results;
    }
}

