/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1x;

import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.kie.dmn.api.marshalling.DMNExtensionRegister;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.backend.marshalling.CustomStaxReader;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.v1_3.URIFEELed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamMarshaller
implements DMNMarshaller {
    private static Logger logger = LoggerFactory.getLogger(XStreamMarshaller.class);
    private List<DMNExtensionRegister> extensionRegisters = new ArrayList<DMNExtensionRegister>();
    private final org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller xstream11;
    private final org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller xstream12;
    private final org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller xstream13;
    private final org.kie.dmn.backend.marshalling.v1_4.xstream.XStreamMarshaller xstream14;
    private final org.kie.dmn.backend.marshalling.v1_5.xstream.XStreamMarshaller xstream15;
    private final org.kie.dmn.backend.marshalling.v1_6.xstream.XStreamMarshaller xstream16;
    private static final StaxDriver staxDriver = new StaxDriver();

    public XStreamMarshaller() {
        this.xstream11 = new org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller();
        this.xstream12 = new org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller();
        this.xstream13 = new org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller();
        this.xstream14 = new org.kie.dmn.backend.marshalling.v1_4.xstream.XStreamMarshaller();
        this.xstream15 = new org.kie.dmn.backend.marshalling.v1_5.xstream.XStreamMarshaller();
        this.xstream16 = new org.kie.dmn.backend.marshalling.v1_6.xstream.XStreamMarshaller();
    }

    public XStreamMarshaller(List<DMNExtensionRegister> extensionRegisters) {
        this.extensionRegisters.addAll(extensionRegisters);
        this.xstream11 = new org.kie.dmn.backend.marshalling.v1_1.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream12 = new org.kie.dmn.backend.marshalling.v1_2.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream13 = new org.kie.dmn.backend.marshalling.v1_3.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream14 = new org.kie.dmn.backend.marshalling.v1_4.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream15 = new org.kie.dmn.backend.marshalling.v1_5.xstream.XStreamMarshaller(extensionRegisters);
        this.xstream16 = new org.kie.dmn.backend.marshalling.v1_6.xstream.XStreamMarshaller(extensionRegisters);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Definitions unmarshal(String xml) {
        try (StringReader firstStringReader = new StringReader(xml);){
            Definitions definitions;
            try (StringReader secondStringReader = new StringReader(xml);){
                Collection<String> nsContextValues = XStreamMarshaller.getNsContextValues(firstStringReader);
                DMN_VERSION inferDMNVersion = XStreamMarshaller.inferDMNVersion(nsContextValues);
                definitions = switch (inferDMNVersion) {
                    case DMN_VERSION.DMN_v1_1 -> this.xstream11.unmarshal(secondStringReader);
                    case DMN_VERSION.DMN_v1_2 -> this.xstream12.unmarshal(secondStringReader);
                    case DMN_VERSION.DMN_v1_3 -> this.xstream13.unmarshal(secondStringReader);
                    case DMN_VERSION.DMN_v1_4 -> this.xstream14.unmarshal(secondStringReader);
                    case DMN_VERSION.DMN_v1_5 -> this.xstream15.unmarshal(secondStringReader);
                    default -> this.xstream16.unmarshal(secondStringReader);
                };
            }
            return definitions;
        }
        catch (Exception e) {
            logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> getNsContextValues(Reader from) {
        Collection<String> toReturn = Collections.emptySet();
        XMLStreamReader xmlReader = null;
        CustomStaxReader customStaxReader = null;
        try {
            xmlReader = staxDriver.getInputFactory().createXMLStreamReader(from);
            customStaxReader = new CustomStaxReader(new QNameMap(), xmlReader);
            toReturn = customStaxReader.getNsContext().values();
        }
        catch (Exception e) {
            logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
        }
        finally {
            if (customStaxReader != null) {
                customStaxReader.close();
            }
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (XMLStreamException e) {
                    logger.error("Error closing xml reader.", (Throwable)e);
                }
            }
        }
        return toReturn;
    }

    public static DMN_VERSION inferDMNVersion(Collection<String> nsContextValues) {
        DMN_VERSION toReturn = DMN_VERSION.UNKNOWN;
        if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20240513/MODEL/"::equals)) {
            toReturn = DMN_VERSION.DMN_v1_6;
        } else if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20230324/MODEL/"::equals)) {
            toReturn = DMN_VERSION.DMN_v1_5;
        } else if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20211108/MODEL/"::equals)) {
            toReturn = DMN_VERSION.DMN_v1_4;
        } else if (nsContextValues.stream().anyMatch("https://www.omg.org/spec/DMN/20191111/MODEL/"::equals)) {
            toReturn = DMN_VERSION.DMN_v1_3;
        } else if (nsContextValues.stream().anyMatch("http://www.omg.org/spec/DMN/20180521/MODEL/"::equals)) {
            toReturn = DMN_VERSION.DMN_v1_2;
        } else if (nsContextValues.stream().anyMatch("http://www.omg.org/spec/DMN/20151101/dmn.xsd"::equals)) {
            toReturn = DMN_VERSION.DMN_v1_1;
        }
        return toReturn;
    }

    public static String getNamespaceValueReflectively(DMN_VERSION dmnVersion, URI_NAMESPACE namespaceKind) {
        try {
            String kieDMNModelInstrumentedBaseClassName = String.format("org.kie.dmn.model.%s.KieDMNModelInstrumentedBase", dmnVersion.getVersionString());
            Class<?> kieDMNModelInstrumentedBaseClass = Class.forName(kieDMNModelInstrumentedBaseClassName);
            Field declaredField = kieDMNModelInstrumentedBaseClass.getDeclaredField(namespaceKind.name());
            return (String)declaredField.get(null);
        }
        catch (NoSuchFieldException e) {
            logger.warn("Could not retrieve {} value reflectively for {}", (Object)namespaceKind, (Object)dmnVersion.getVersionString());
            return null;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Definitions unmarshal(Reader isr) {
        Definitions definitions;
        BufferedReader buffer = new BufferedReader(isr);
        try {
            String xml = buffer.lines().collect(Collectors.joining("\n"));
            definitions = this.unmarshal(xml);
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Error unmarshalling DMN model from reader.", (Throwable)e);
                return null;
            }
        }
        buffer.close();
        return definitions;
    }

    public String marshal(Object o) {
        if (o instanceof org.kie.dmn.model.v1_6.URIFEELed) {
            return this.xstream16.marshal(o);
        }
        if (o instanceof org.kie.dmn.model.v1_5.URIFEELed) {
            return this.xstream15.marshal(o);
        }
        if (o instanceof org.kie.dmn.model.v1_4.URIFEELed) {
            return this.xstream14.marshal(o);
        }
        if (o instanceof URIFEELed) {
            return this.xstream13.marshal(o);
        }
        if (o instanceof org.kie.dmn.model.v1_2.URIFEELed) {
            return this.xstream12.marshal(o);
        }
        if (o instanceof org.kie.dmn.model.v1_1.URIFEELed) {
            return this.xstream11.marshal(o);
        }
        return this.xstream14.marshal(o);
    }

    public void marshal(Object o, Writer out) {
        if (o instanceof org.kie.dmn.model.v1_6.URIFEELed) {
            this.xstream16.marshal(o, out);
        } else if (o instanceof org.kie.dmn.model.v1_5.URIFEELed) {
            this.xstream15.marshal(o, out);
        } else if (o instanceof org.kie.dmn.model.v1_4.URIFEELed) {
            this.xstream14.marshal(o, out);
        } else if (o instanceof URIFEELed) {
            this.xstream13.marshal(o, out);
        } else if (o instanceof org.kie.dmn.model.v1_2.URIFEELed) {
            this.xstream12.marshal(o, out);
        } else if (o instanceof org.kie.dmn.model.v1_1.URIFEELed) {
            this.xstream11.marshal(o, out);
        } else {
            this.xstream14.marshal(o, out);
        }
    }

    public static enum DMN_VERSION {
        UNKNOWN(""),
        DMN_v1_1("v1_1"),
        DMN_v1_2("v1_2"),
        DMN_v1_3("v1_3"),
        DMN_v1_4("v1_4"),
        DMN_v1_5("v1_5"),
        DMN_v1_6("v1_6");

        final String versionString;

        private DMN_VERSION(String versionString) {
            this.versionString = versionString;
        }

        public String getVersionString() {
            return this.versionString;
        }
    }

    public static enum URI_NAMESPACE {
        URI_DMN("MODEL"),
        URI_FEEL("FEEL"),
        URI_DMNDI("DMNDI"),
        URI_DI("DI"),
        URI_DC("DC");

        private final String identifier;

        private URI_NAMESPACE(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }
}

