/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_6.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_6.xstream.DMNModelInstrumentedBaseConverter;
import org.kie.dmn.model.api.dmndi.DiagramElement;
import org.kie.dmn.model.api.dmndi.Style;
import org.kie.dmn.model.v1_6.dmndi.Style;

public abstract class DiagramElementConverter
extends DMNModelInstrumentedBaseConverter {
    private static final String STYLE = "style";
    private static final String SHARED_STYLE = "sharedStyle";
    private static final String EXTENSION = "extension";
    private static final String ID = "id";

    public DiagramElementConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
        DiagramElement abs = (DiagramElement)parent;
        if (child instanceof DiagramElement.Extension) {
            abs.setExtension((DiagramElement.Extension)child);
        } else if (child instanceof Style) {
            abs.setStyle((Style)child);
        } else {
            super.assignChildElement(abs, nodeName, child);
        }
    }

    @Override
    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        String sharedStyleXmlSerialization;
        super.assignAttributes(reader, parent);
        DiagramElement abs = (DiagramElement)parent;
        String id = reader.getAttribute(ID);
        if (id != null) {
            abs.setId(id);
        }
        if ((sharedStyleXmlSerialization = reader.getAttribute(SHARED_STYLE)) != null) {
            abs.setSharedStyle((Style)new Style.IDREFStubStyle(sharedStyleXmlSerialization));
        }
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        DiagramElement abs = (DiagramElement)parent;
        if (abs.getExtension() != null) {
            this.writeChildrenNode(writer, context, abs.getExtension(), EXTENSION);
        }
        if (abs.getStyle() != null) {
            this.writeChildrenNode(writer, context, abs.getStyle(), STYLE);
        }
    }

    @Override
    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        super.writeAttributes(writer, parent);
        DiagramElement abs = (DiagramElement)parent;
        if (abs.getId() != null) {
            writer.addAttribute(ID, abs.getId());
        }
        if (abs.getSharedStyle() != null) {
            writer.addAttribute(SHARED_STYLE, abs.getSharedStyle().getId());
        }
    }
}

