/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.utils;

import java.io.File;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileNameUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileNameUtils.class);

    private FileNameUtils() {
    }

    public static String getFileName(String source) {
        String sourceToUse = source;
        try {
            sourceToUse = new URI(source).toURL().getFile();
        }
        catch (Exception e) {
            LOGGER.debug("Can't parse the given source {} as URI", (Object)source);
        }
        return new File(sourceToUse).getName();
    }

    public static String getSuffix(String fileName) {
        return fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
    }

    public static String removeSuffix(String fileName) {
        return fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
    }
}

