/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.util.deployment;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.drools.codegen.common.AppPaths;

public class QuarkusAppPaths
extends AppPaths {
    private static final Path MUTABLE_JAR_PATH = Paths.get("dev", "app");

    protected QuarkusAppPaths(List<Path> projectPaths, Collection<Path> classesPaths, boolean isJar) {
        super(projectPaths, classesPaths, isJar, AppPaths.BT, "main", false);
    }

    public static AppPaths from(Iterable<Path> paths) {
        LinkedHashSet<Path> projectPaths = new LinkedHashSet<Path>();
        ArrayList<Path> classesPaths = new ArrayList<Path>();
        boolean isJar = false;
        for (Path path : paths) {
            PathType pathType = QuarkusAppPaths.getPathType(path);
            switch (pathType) {
                case CLASSES: {
                    classesPaths.add(path);
                    projectPaths.add(QuarkusAppPaths.getParentPath(path));
                    break;
                }
                case TEST_CLASSES: {
                    projectPaths.add(QuarkusAppPaths.getParentPath(path));
                    break;
                }
                case JAR: {
                    isJar = true;
                    classesPaths.add(path);
                    projectPaths.add(QuarkusAppPaths.getParentPath(path));
                    break;
                }
                case MUTABLE_JAR: {
                    return new QuarkusAppPaths(Collections.singletonList(path), Collections.singleton(path), false);
                }
                case UNKNOWN: {
                    classesPaths.add(path);
                    projectPaths.add(path);
                }
            }
        }
        return new QuarkusAppPaths(new ArrayList<Path>(projectPaths), classesPaths, isJar);
    }

    private static Path getParentPath(Path path) {
        if (AppPaths.BT.equals((Object)AppPaths.BuildTool.GRADLE)) {
            return path.getParent().getParent().getParent().getParent();
        }
        return path.getParent().getParent();
    }

    private static PathType getPathType(Path archiveLocation) {
        if (archiveLocation.endsWith(MUTABLE_JAR_PATH)) {
            return PathType.MUTABLE_JAR;
        }
        if (archiveLocation.endsWith(AppPaths.BT.CLASSES_PATH)) {
            return PathType.CLASSES;
        }
        if (archiveLocation.endsWith(AppPaths.BT.TEST_CLASSES_PATH)) {
            return PathType.TEST_CLASSES;
        }
        if (archiveLocation.toString().toLowerCase().endsWith(".jar") || archiveLocation.toString().toLowerCase().endsWith(".jar.original")) {
            return PathType.JAR;
        }
        return PathType.UNKNOWN;
    }

    private static enum PathType {
        CLASSES,
        TEST_CLASSES,
        JAR,
        MUTABLE_JAR,
        UNKNOWN;

    }
}

