/*
 * Decompiled with CFR 0.152.
 */
package org.drools.quarkus.util.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.resteasy.reactive.spi.GeneratedJaxRsResourceBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.model.codegen.execmodel.PackageModel;
import org.drools.model.codegen.project.RuleCodegen;
import org.drools.quarkus.util.deployment.DroolsQuarkusResourceUtils;
import org.drools.quarkus.util.deployment.GlobalsBuildItem;
import org.drools.quarkus.util.deployment.KmoduleKieBaseModelsBuiltItem;
import org.drools.quarkus.util.deployment.PatternsTypesBuildItem;
import org.drools.quarkus.util.deployment.ResourceCollector;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.PrototypesOption;
import org.kie.api.conf.SessionsPoolOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDroolsAssetsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDroolsAssetsProcessor.class);
    private static final String CONFIG_PREFIX = "drools.kbase.";
    private static final String ASSET_DEPENDENCIES_CONFIG = "drools.asset.dependencies";

    public void generateSources(ArchiveRootBuildItem root, LiveReloadBuildItem liveReload, CurateOutcomeBuildItem curateOutcomeBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<AdditionalStaticResourceBuildItem> staticResProducer, BuildProducer<GeneratedResourceBuildItem> genResBI, BuildProducer<PatternsTypesBuildItem> otnClasesBI, BuildProducer<KmoduleKieBaseModelsBuiltItem> kbaseModelsBI, BuildProducer<GlobalsBuildItem> globalsBI, BuildProducer<GeneratedJaxRsResourceBuildItem> jaxrsProducer) {
        DroolsModelBuildContext context = DroolsQuarkusResourceUtils.createDroolsBuildContext((Iterable<Path>)root.getPaths(), combinedIndexBuildItem.getIndex());
        Path[] assetPaths = this.getAssetPaths(context, curateOutcomeBuildItem);
        Collection<Resource> resources = ResourceCollector.fromPaths(assetPaths);
        RuleCodegen ruleCodegen = RuleCodegen.ofResources((DroolsModelBuildContext)context, resources).withKieBaseModels(this.readKieBaseModels());
        Collection generatedFiles = ruleCodegen.generate();
        generatedFiles.addAll(DroolsQuarkusResourceUtils.getRuleUnitDefProducerSource(combinedIndexBuildItem.getIndex()));
        if (!liveReload.isLiveReload()) {
            generatedFiles.add(new GeneratedFile(GeneratedFileType.SOURCE, DroolsQuarkusResourceUtils.HOT_RELOAD_SUPPORT_PATH + ".java", DroolsQuarkusResourceUtils.getHotReloadSupportSource()));
        }
        DroolsQuarkusResourceUtils.dumpFilesToDisk(context.getAppPaths(), generatedFiles);
        Collection dependencies = curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        Collection<GeneratedBeanBuildItem> generatedBeanBuildItems = DroolsQuarkusResourceUtils.compileGeneratedSources(context, dependencies, generatedFiles, liveReload.isLiveReload());
        generatedBeanBuildItems.forEach(arg_0 -> generatedBeans.produce(arg_0));
        DroolsQuarkusResourceUtils.registerResources(generatedFiles, staticResProducer, resource, genResBI);
        otnClasesBI.produce((BuildItem)new PatternsTypesBuildItem(ruleCodegen.getPackageModels().stream().collect(Collectors.toMap(PackageModel::getName, PackageModel::getOtnsClasses))));
        if (ruleCodegen.hasKieBaseModels()) {
            kbaseModelsBI.produce((BuildItem)new KmoduleKieBaseModelsBuiltItem(ruleCodegen.getKmoduleKieBaseModels()));
        }
        globalsBI.produce((BuildItem)new GlobalsBuildItem(ruleCodegen.getPackageModels().stream().collect(Collectors.toMap(PackageModel::getName, PackageModel::getGlobals))));
        Set restResourceClassNameSet = generatedFiles.stream().filter(file -> file.type() == GeneratedFileType.REST).map(file -> DroolsQuarkusResourceUtils.toClassName(file.path().toString())).collect(Collectors.toSet());
        generatedBeanBuildItems.stream().filter(b -> restResourceClassNameSet.contains(b.getName())).forEach(b -> jaxrsProducer.produce((BuildItem)new GeneratedJaxRsResourceBuildItem(b.getName(), b.getData())));
    }

    private Path[] getAssetPaths(DroolsModelBuildContext context, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        Path[] appPaths = context.getAppPaths().getPaths();
        Config config = ConfigProvider.getConfig();
        Optional assetDependenciesOpt = config.getOptionalValues(ASSET_DEPENDENCIES_CONFIG, String.class);
        if (assetDependenciesOpt.isPresent()) {
            List<String> assetDependencies = ((List)assetDependenciesOpt.get()).stream().map(String::trim).toList();
            Iterable directDependenciesIter = curateOutcomeBuildItem.getApplicationModel().getDependencies(2);
            List directDependencies = StreamSupport.stream(directDependenciesIter.spliterator(), false).toList();
            Path[] assetDependencyPaths = (Path[])directDependencies.stream().filter(d -> assetDependencies.contains(d.getGroupId() + ":" + d.getArtifactId())).flatMap(d -> d.getResolvedPaths().stream()).toArray(Path[]::new);
            LOGGER.debug("assetDependencyPaths: {}", Arrays.asList(assetDependencyPaths));
            return (Path[])Stream.concat(Arrays.stream(assetDependencyPaths), Arrays.stream(appPaths)).toArray(Path[]::new);
        }
        return appPaths;
    }

    private Map<String, KieBaseModel> readKieBaseModels() {
        HashMap<String, KieBaseModel> kieBaseModels = new HashMap<String, KieBaseModel>();
        Config config = ConfigProvider.getConfig();
        block30: for (String propertyName : config.getPropertyNames()) {
            if (!propertyName.startsWith(CONFIG_PREFIX)) continue;
            String[] splitProp = propertyName.substring(CONFIG_PREFIX.length()).split("\\.");
            if (splitProp.length < 2) {
                LOGGER.error("Malformed Drools property: " + propertyName);
                continue;
            }
            String kBaseName = splitProp[0];
            KieBaseModel kieBaseModel = kieBaseModels.computeIfAbsent(kBaseName, KieBaseModelImpl::new);
            block10 : switch (splitProp[1]) {
                case "packages": {
                    for (String pkg : ((String)config.getValue(propertyName, String.class)).split("\\,")) {
                        kieBaseModel.addPackage(pkg);
                    }
                    continue block30;
                }
                case "default": {
                    kieBaseModel.setDefault(((Boolean)config.getValue(propertyName, Boolean.class)).booleanValue());
                    break;
                }
                case "prototypes": {
                    kieBaseModel.setPrototypes(PrototypesOption.determinePrototypesOption((String)((String)config.getValue(propertyName, String.class))));
                    break;
                }
                case "eventProcessingMode": {
                    kieBaseModel.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)((String)config.getValue(propertyName, String.class))));
                    break;
                }
                case "mutability": {
                    kieBaseModel.setMutability(KieBaseMutabilityOption.determineMutability((String)((String)config.getValue(propertyName, String.class))));
                    break;
                }
                case "sessionsPool": {
                    kieBaseModel.setSessionsPool(SessionsPoolOption.get((int)((Integer)config.getValue(propertyName, Integer.class))));
                    break;
                }
                case "ksessions": {
                    for (String ksession : ((String)config.getValue(propertyName, String.class)).split("\\,")) {
                        kieBaseModel.newKieSessionModel(ksession);
                    }
                    continue block30;
                }
                case "ksession": {
                    if (splitProp.length == 2) {
                        kieBaseModel.newKieSessionModel((String)config.getValue(propertyName, String.class));
                        break;
                    }
                    if (splitProp.length < 4) {
                        LOGGER.error("Malformed Drools property: " + propertyName);
                        break;
                    }
                    String kSessionName = splitProp[2];
                    KieSessionModel kieSessionModel = (KieSessionModel)kieBaseModel.getKieSessionModels().get(kSessionName);
                    if (kieSessionModel == null) {
                        kieSessionModel = kieBaseModel.newKieSessionModel(kSessionName);
                    }
                    switch (splitProp[3]) {
                        case "default": {
                            kieSessionModel.setDefault(((Boolean)config.getValue(propertyName, Boolean.class)).booleanValue());
                            break block10;
                        }
                        case "stateless": {
                            kieSessionModel.setType((Boolean)config.getValue(propertyName, Boolean.class) != false ? KieSessionModel.KieSessionType.STATELESS : KieSessionModel.KieSessionType.STATEFUL);
                            break block10;
                        }
                        case "clockType": {
                            kieSessionModel.setClockType(ClockTypeOption.get((String)((String)config.getValue(propertyName, String.class))));
                        }
                    }
                }
            }
        }
        return kieBaseModels;
    }
}

