/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import org.mvel2.asm.MethodVisitor;

public class TypeConversionHelper {
    public static final String GET_DECIMAL_VALUE = "getDecimalValue";
    public static final String GET_WHOLE_NUMBER_VALUE = "getWholeNumberValue";
    public static final String GET_VALUE = "getValue";

    public static ConversionType determineConversionType(String readMethod, String declarationType) {
        if (GET_DECIMAL_VALUE.equals(readMethod)) {
            if ("float".equals(declarationType) || "java.lang.Float".equals(declarationType)) {
                return ConversionType.FLOAT;
            }
        } else if (GET_WHOLE_NUMBER_VALUE.equals(readMethod)) {
            return switch (declarationType) {
                case "byte", "java.lang.Byte" -> ConversionType.BYTE;
                case "short", "java.lang.Short" -> ConversionType.SHORT;
                case "int" -> ConversionType.INT;
                case "java.lang.Integer" -> ConversionType.INTEGER_OBJECT;
                case "char", "java.lang.Character" -> ConversionType.CHAR;
                default -> ConversionType.NONE;
            };
        }
        return ConversionType.NONE;
    }

    public static String getActualReturnType(String readMethod, boolean isObject, String typeDescr) {
        if (GET_DECIMAL_VALUE.equals(readMethod)) {
            return "D";
        }
        if (GET_WHOLE_NUMBER_VALUE.equals(readMethod)) {
            return "J";
        }
        return isObject ? "Ljava/lang/Object;" : typeDescr;
    }

    public static void emitTypeConversion(MethodVisitor mv, ConversionType conversionType) {
        switch (conversionType) {
            case FLOAT: {
                mv.visitInsn(144);
                break;
            }
            case BYTE: {
                mv.visitInsn(136);
                mv.visitInsn(145);
                break;
            }
            case SHORT: {
                mv.visitInsn(136);
                mv.visitInsn(147);
                break;
            }
            case INT: {
                mv.visitInsn(136);
                break;
            }
            case CHAR: {
                mv.visitInsn(136);
                break;
            }
            case INTEGER_OBJECT: {
                mv.visitInsn(136);
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                break;
            }
        }
    }

    public static enum ConversionType {
        NONE,
        FLOAT,
        BYTE,
        SHORT,
        INT,
        CHAR,
        INTEGER_OBJECT;

    }
}

