/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.model.Model;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.KiePackagesBuilder;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.Option;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;

public class KieBaseBuilder {
    private final String kBaseName;
    private final KieBaseConfiguration conf;

    public KieBaseBuilder() {
        this(null, null);
    }

    public KieBaseBuilder(KieBaseConfiguration conf) {
        this(null, conf);
    }

    public KieBaseBuilder(KieBaseModel kBaseModel, KieBaseConfiguration conf) {
        this.conf = conf;
        this.kBaseName = kBaseModel != null ? kBaseModel.getName() : "defaultkiebase";
    }

    public InternalKnowledgeBase createKieBase(CanonicalKiePackages kpkgs) {
        InternalKnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase((String)this.kBaseName, (KieBaseConfiguration)this.conf);
        kBase.addPackages(kpkgs.getKiePackages());
        return kBase;
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Model model, KieBaseOption ... options) {
        return KieBaseBuilder.createKieBaseFromModel(Collections.singleton(model), options);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Model model, KieBaseConfiguration kieBaseConf) {
        return KieBaseBuilder.createKieBaseFromModel(Collections.singleton(model), kieBaseConf);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Model model, KieBaseConfiguration kieBaseConf, KnowledgeBuilderConfiguration knowledgeBuilderConf) {
        return KieBaseBuilder.createKieBaseFromModel(Collections.singleton(model), kieBaseConf, knowledgeBuilderConf);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Collection<Model> models, KieBaseOption ... options) {
        KieBaseConfiguration kieBaseConf = KieServices.get().newKieBaseConfiguration();
        if (options != null) {
            for (KieBaseOption option : options) {
                kieBaseConf.setOption((Option)option);
            }
        }
        return KieBaseBuilder.createKieBaseFromModel(models, kieBaseConf);
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Collection<Model> models, KieBaseConfiguration kieBaseConf) {
        KiePackagesBuilder builder = new KiePackagesBuilder(kieBaseConf);
        models.forEach(builder::addModel);
        return new KieBaseBuilder(kieBaseConf).createKieBase(builder.build());
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Collection<Model> models, KieBaseConfiguration kieBaseConf, KnowledgeBuilderConfiguration knowledgeBuilderConf) {
        KiePackagesBuilder builder = new KiePackagesBuilder(kieBaseConf, knowledgeBuilderConf, new ArrayList<Model>());
        models.forEach(builder::addModel);
        return new KieBaseBuilder(kieBaseConf).createKieBase(builder.build());
    }

    public static InternalKnowledgeBase createKieBaseFromModel(Collection<Model> models, KieBaseModel kieBaseModel, KieModuleModel kieModuleModel) {
        KieBaseConfiguration conf = KieServices.get().newKieBaseConfiguration();
        RuleBaseConfiguration kieBaseConf = (RuleBaseConfiguration)conf.as(RuleBaseConfiguration.KEY);
        kieBaseConf.setEventProcessingMode(kieBaseModel.getEventProcessingMode());
        kieBaseConf.setSessionPoolSize(kieBaseModel.getSessionsPool().getSize());
        KiePackagesBuilder builder = new KiePackagesBuilder(conf);
        models.stream().filter(m -> KieBuilderImpl.isPackageInKieBaseOrIncludedKieBases((String)m.getPackageName(), (KieBaseModel)kieBaseModel, (KieModuleModel)kieModuleModel)).forEach(builder::addModel);
        return new KieBaseBuilder(kieBaseModel, conf).createKieBase(builder.build());
    }
}

