/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.entrypoints;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.rule.EntryPointId;
import org.drools.core.EntryPointsManager;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.rule.accessor.FactHandleFactory;

public class NamedEntryPointsManager
implements EntryPointsManager {
    private final ReteEvaluator reteEvaluator;
    private final InternalRuleBase ruleBase;
    InternalWorkingMemoryEntryPoint defaultEntryPoint;
    private final Map<String, WorkingMemoryEntryPoint> entryPoints = new ConcurrentHashMap<String, WorkingMemoryEntryPoint>();
    private FactHandleFactory factHandleFactory;

    public NamedEntryPointsManager(InternalRuleBase ruleBase, ReteEvaluator reteEvaluator, FactHandleFactory factHandleFactory) {
        this.reteEvaluator = reteEvaluator;
        this.ruleBase = ruleBase;
        this.factHandleFactory = factHandleFactory;
        this.initDefaultEntryPoint();
        this.updateEntryPointsCache();
    }

    public InternalWorkingMemoryEntryPoint getDefaultEntryPoint() {
        return this.defaultEntryPoint;
    }

    public WorkingMemoryEntryPoint getEntryPoint(String name) {
        return this.entryPoints.get(name);
    }

    public Collection<WorkingMemoryEntryPoint> getEntryPoints() {
        return this.entryPoints.values();
    }

    private InternalWorkingMemoryEntryPoint createNamedEntryPoint(EntryPointNode addedNode) {
        return RuntimeComponentFactory.get().getEntryPointFactory().createEntryPoint(this.ruleBase, this.reteEvaluator, this.factHandleFactory, addedNode.getEntryPoint(), addedNode);
    }

    public void updateEntryPointsCache() {
        if (this.ruleBase.getAddedEntryNodeCache() != null) {
            for (EntryPointNode addedNode : this.ruleBase.getAddedEntryNodeCache()) {
                this.entryPoints.computeIfAbsent(addedNode.getEntryPoint().getEntryPointId(), x -> this.createNamedEntryPoint(addedNode));
            }
        }
        if (this.ruleBase.getRemovedEntryNodeCache() != null) {
            for (EntryPointNode removedNode : this.ruleBase.getRemovedEntryNodeCache()) {
                this.entryPoints.remove(removedNode.getEntryPoint().getEntryPointId());
            }
        }
    }

    public void reset() {
        this.defaultEntryPoint.reset();
        this.updateEntryPointsCache();
    }

    private void initDefaultEntryPoint() {
        this.defaultEntryPoint = this.createNamedEntryPoint(this.ruleBase.getRete().getEntryPointNode(EntryPointId.DEFAULT));
        this.entryPoints.clear();
        this.entryPoints.put(EntryPointId.DEFAULT.getEntryPointId(), (WorkingMemoryEntryPoint)this.defaultEntryPoint);
    }
}

